/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.pan.Messages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.version.BuildVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Pan {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a) throws KettleException {
        EnvUtil.environmentInit();
        JndiUtil.initJNDI();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length() <= 0) continue;
            args.add(a[i]);
        }
        RepositoryMeta repinfo = null;
        UserInfo userinfo = null;
        Trans trans = null;
        NamedParamsDefault optionParams = new NamedParamsDefault();
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[19];
        StringBuffer optionRepname = new StringBuffer();
        commandLineOptionArray[0] = new CommandLineOption("rep", Messages.getString("Pan.ComdLine.RepName"), optionRepname);
        StringBuffer optionUsername = new StringBuffer();
        commandLineOptionArray[1] = new CommandLineOption("user", Messages.getString("Pan.ComdLine.RepUsername"), optionUsername);
        StringBuffer optionPassword = new StringBuffer();
        commandLineOptionArray[2] = new CommandLineOption("pass", Messages.getString("Pan.ComdLine.RepPassword"), optionPassword);
        StringBuffer optionTransname = new StringBuffer();
        commandLineOptionArray[3] = new CommandLineOption("trans", Messages.getString("Pan.ComdLine.TransName"), optionTransname);
        StringBuffer optionDirname = new StringBuffer();
        commandLineOptionArray[4] = new CommandLineOption("dir", Messages.getString("Pan.ComdLine.RepDir"), optionDirname);
        StringBuffer optionFilename = new StringBuffer();
        commandLineOptionArray[5] = new CommandLineOption("file", Messages.getString("Pan.ComdLine.XMLTransFile"), optionFilename);
        StringBuffer optionLoglevel = new StringBuffer();
        commandLineOptionArray[6] = new CommandLineOption("level", Messages.getString("Pan.ComdLine.LogLevel"), optionLoglevel);
        StringBuffer optionLogfile = new StringBuffer();
        commandLineOptionArray[7] = new CommandLineOption("logfile", Messages.getString("Pan.ComdLine.LogFile"), optionLogfile);
        StringBuffer optionLogfileOld = new StringBuffer();
        commandLineOptionArray[8] = new CommandLineOption("log", Messages.getString("Pan.ComdLine.LogOldFile"), optionLogfileOld, false, true);
        StringBuffer optionListdir = new StringBuffer();
        commandLineOptionArray[9] = new CommandLineOption("listdir", Messages.getString("Pan.ComdLine.ListDirRep"), optionListdir, true, false);
        StringBuffer optionListtrans = new StringBuffer();
        commandLineOptionArray[10] = new CommandLineOption("listtrans", Messages.getString("Pan.ComdLine.ListTransDir"), optionListtrans, true, false);
        StringBuffer optionListrep = new StringBuffer();
        commandLineOptionArray[11] = new CommandLineOption("listrep", Messages.getString("Pan.ComdLine.ListReps"), optionListrep, true, false);
        StringBuffer optionExprep = new StringBuffer();
        commandLineOptionArray[12] = new CommandLineOption("exprep", Messages.getString("Pan.ComdLine.ExpObjectsXML"), optionExprep, true, false);
        StringBuffer optionNorep = new StringBuffer();
        commandLineOptionArray[13] = new CommandLineOption("norep", Messages.getString("Pan.ComdLine.NoRep"), optionNorep, true, false);
        StringBuffer optionSafemode = new StringBuffer();
        commandLineOptionArray[14] = new CommandLineOption("safemode", Messages.getString("Pan.ComdLine.SafeMode"), optionSafemode, true, false);
        StringBuffer optionVersion = new StringBuffer();
        commandLineOptionArray[15] = new CommandLineOption("version", Messages.getString("Pan.ComdLine.Version"), optionVersion, true, false);
        StringBuffer optionJarFilename = new StringBuffer();
        commandLineOptionArray[16] = new CommandLineOption("jarfile", Messages.getString("Pan.ComdLine.JarFile"), optionJarFilename, false, true);
        commandLineOptionArray[17] = new CommandLineOption("param", Messages.getString("Pan.ComdLine.Param"), (NamedParams)optionParams, false);
        StringBuffer optionListParam = new StringBuffer();
        commandLineOptionArray[18] = new CommandLineOption("listparam", Messages.getString("Pan.ComdLine.ListParam"), optionListParam, true, false);
        CommandLineOption[] options = commandLineOptionArray;
        if (args.size() == 0) {
            CommandLineOption.printUsage(options);
            Pan.exitJVM(9);
        }
        LogWriter.setConsoleAppenderDebug();
        LogWriter log = LogWriter.getInstance((int)3);
        if (!CommandLineOption.parseArguments(args, options, log)) {
            log.logError("Pan", Messages.getString("Pan.Error.CommandLineError"), new Object[0]);
            Pan.exitJVM(8);
        }
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (kettleRepname != null && kettleRepname.length() > 0) {
            optionRepname = new StringBuffer(kettleRepname);
        }
        if (kettleUsername != null && kettleUsername.length() > 0) {
            optionUsername = new StringBuffer(kettleUsername);
        }
        if (kettlePassword != null && kettlePassword.length() > 0) {
            optionPassword = new StringBuffer(kettlePassword);
        }
        if (Const.isEmpty((StringBuffer)optionLogfile) && !Const.isEmpty((StringBuffer)optionLogfileOld)) {
            optionLogfile = optionLogfileOld;
        }
        if (!Const.isEmpty((StringBuffer)optionLogfile)) {
            log = LogWriter.getInstance((String)optionLogfile.toString(), (boolean)true, (int)3);
        }
        if (!Const.isEmpty((StringBuffer)optionLoglevel)) {
            log.setLogLevel(optionLoglevel.toString());
            log.logMinimal("Pan", Messages.getString("Pan.Log.Loglevel", log.getLogLevelLongDesc()), new Object[0]);
        }
        if (!Const.isEmpty((StringBuffer)optionVersion)) {
            BuildVersion buildVersion = BuildVersion.getInstance();
            if (log.isBasic()) {
                log.logBasic("Pan", Messages.getString("Pan.Log.KettleVersion", buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()), new Object[0]);
            }
            if (a.length == 1) {
                Pan.exitJVM(6);
            }
        }
        if (log.isDebug()) {
            System.out.println("Arguments:");
            for (int i = 0; i < options.length; ++i) {
                System.out.println(Const.rightPad((String)options[i].getOption(), (int)12) + " : " + options[i].getArgument());
            }
            System.out.println("");
        }
        log.logMinimal("Pan", Messages.getString("Pan.Log.StartingToRun"), new Object[0]);
        try {
            StepLoader.init();
        }
        catch (KettleException e) {
            log.logError("Pan", Messages.getString("Pan.Error.LoadingStepsHaltPan"), new Object[0]);
            Pan.exitJVM(8);
        }
        try {
            JobEntryLoader.init();
        }
        catch (KettleException e) {
            log.logError("Pan", Messages.getString("Pan.Error.LoadingJobEntriesHaltPan"), (Throwable)e);
            Pan.exitJVM(8);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Calendar cal = Calendar.getInstance();
        Date start = cal.getTime();
        if (log.isDebug()) {
            log.logDebug("Pan", Messages.getString("Pan.Log.AllocatteNewTrans"), new Object[0]);
        }
        TransMeta transMeta = new TransMeta();
        Repository rep = null;
        try {
            if (log.isDebug()) {
                log.logDebug("Pan", Messages.getString("Pan.Log.StartingToLookOptions"), new Object[0]);
            }
            if (!(Const.isEmpty((StringBuffer)optionRepname) && Const.isEmpty((StringBuffer)optionFilename) && Const.isEmpty((StringBuffer)optionJarFilename))) {
                if (log.isDebug()) {
                    log.logDebug("Pan", Messages.getString("Pan.Log.ParsingCommandline"), new Object[0]);
                }
                if (!Const.isEmpty((StringBuffer)optionRepname) && !"Y".equalsIgnoreCase(optionNorep.toString())) {
                    RepositoriesMeta repsinfo;
                    if (log.isDebug()) {
                        log.logDebug("Pan", Messages.getString("Pan.Log.LoadingAvailableRep"), new Object[0]);
                    }
                    if ((repsinfo = new RepositoriesMeta(log)).readData()) {
                        if (log.isDebug()) {
                            log.logDebug("Pan", Messages.getString("Pan.Log.FindingRep", "" + optionRepname), new Object[0]);
                        }
                        if ((repinfo = repsinfo.findRepository(optionRepname.toString())) != null) {
                            if (log.isDebug()) {
                                log.logDebug("Pan", Messages.getString("Pan.Log.Allocate&ConnectRep"), new Object[0]);
                            }
                            if ((rep = new Repository(log, repinfo, userinfo)).connect("Pan commandline")) {
                                RepositoryDirectory directory = rep.getDirectoryTree();
                                if (!Const.isEmpty((StringBuffer)optionDirname)) {
                                    directory = rep.getDirectoryTree().findDirectory(optionDirname.toString());
                                }
                                if (directory != null) {
                                    if (log.isDebug()) {
                                        log.logDebug("Pan", Messages.getString("Pan.Log.CheckSuppliedUserPass"), new Object[0]);
                                    }
                                    if ((userinfo = new UserInfo(rep, optionUsername.toString(), optionPassword.toString())).getID() > 0L) {
                                        int i;
                                        if (!Const.isEmpty((StringBuffer)optionTransname)) {
                                            if (log.isDebug()) {
                                                log.logDebug("Pan", Messages.getString("Pan.Log.LoadTransInfo"), new Object[0]);
                                            }
                                            transMeta = new TransMeta(rep, optionTransname.toString(), directory);
                                            if (log.isDebug()) {
                                                log.logDebug("Pan", Messages.getString("Pan.Log.AllocateTrans"), new Object[0]);
                                            }
                                            trans = new Trans(transMeta);
                                            trans.setRepository(rep);
                                        } else if ("Y".equalsIgnoreCase(optionListtrans.toString())) {
                                            if (log.isDebug()) {
                                                log.logDebug("Pan", Messages.getString("Pan.Log.GettingListTransDirectory", "" + directory), new Object[0]);
                                            }
                                            String[] transnames = rep.getTransformationNames(directory.getID());
                                            for (i = 0; i < transnames.length; ++i) {
                                                System.out.println(transnames[i]);
                                            }
                                        } else if ("Y".equalsIgnoreCase(optionListdir.toString())) {
                                            String[] dirnames = rep.getDirectoryNames(directory.getID());
                                            for (i = 0; i < dirnames.length; ++i) {
                                                System.out.println(dirnames[i]);
                                            }
                                        } else if (!Const.isEmpty((StringBuffer)optionExprep)) {
                                            System.out.println(Messages.getString("Pan.Log.ExportingObjectsRepToFile", "" + optionExprep));
                                            rep.exportAllObjects(null, optionExprep.toString(), directory, "all");
                                            System.out.println(Messages.getString("Pan.Log.FinishedExportObjectsRepToFile", "" + optionExprep));
                                        } else {
                                            System.out.println(Messages.getString("Pan.Error.NoTransNameSupplied"));
                                        }
                                    } else {
                                        System.out.println(Messages.getString("Pan.Error.CanNotVerifyUserPass"));
                                        userinfo = null;
                                        repinfo = null;
                                    }
                                } else {
                                    System.out.println(Messages.getString("Pan.Error.CanNotFindSpecifiedDirectory", "" + optionDirname));
                                    userinfo = null;
                                    repinfo = null;
                                }
                            } else {
                                System.out.println(Messages.getString("Pan.Error.CanNotConnectRep"));
                            }
                        } else {
                            System.out.println(Messages.getString("Pan.Error.NoRepProvided"));
                        }
                    } else {
                        System.out.println(Messages.getString("Pan.Error.NoRepsDefined"));
                    }
                }
                if (trans == null && !Const.isEmpty((StringBuffer)optionFilename)) {
                    if (log.isDetailed()) {
                        log.logDetailed("Pan", Messages.getString("Pan.Log.LoadingTransXML", "" + optionFilename), new Object[0]);
                    }
                    transMeta = new TransMeta(optionFilename.toString());
                    trans = new Trans(transMeta);
                }
                if (trans == null && !Const.isEmpty((StringBuffer)optionJarFilename)) {
                    try {
                        int c;
                        if (log.isDetailed()) {
                            log.logDetailed("Pan", Messages.getString("Pan.Log.LoadingTransJar", "" + optionJarFilename), new Object[0]);
                        }
                        InputStream inputStream = Pan.class.getResourceAsStream(optionJarFilename.toString());
                        StringBuffer xml = new StringBuffer();
                        while ((c = inputStream.read()) != -1) {
                            xml.append((char)c);
                        }
                        inputStream.close();
                        Document document = XMLHandler.loadXMLString((String)xml.toString());
                        transMeta = new TransMeta(XMLHandler.getSubNode((Node)document, (String)"transformation"), null);
                        trans = new Trans(transMeta);
                    }
                    catch (Exception e) {
                        System.out.println(Messages.getString("Pan.Error.ReadingJar", e.toString()));
                        System.out.println(Const.getStackTracker((Throwable)e));
                        throw e;
                    }
                }
            }
            if ("Y".equalsIgnoreCase(optionListrep.toString())) {
                RepositoriesMeta ri;
                if (log.isDebug()) {
                    log.logDebug("Pan", Messages.getString("Pan.Log.GettingListReps"), new Object[0]);
                }
                if ((ri = new RepositoriesMeta(log)).readData()) {
                    System.out.println(Messages.getString("Pan.Log.ListReps"));
                    for (int i = 0; i < ri.nrRepositories(); ++i) {
                        RepositoryMeta rinfo = ri.getRepository(i);
                        System.out.println(Messages.getString("Pan.Log.RepNameDesc", "" + (i + 1), rinfo.getName(), rinfo.getDescription()));
                    }
                } else {
                    System.out.println(Messages.getString("Pan.Error.UnableReadXML"));
                }
            }
        }
        catch (Exception e) {
            trans = null;
            transMeta = null;
            if (rep != null) {
                rep.disconnect();
            }
            System.out.println(Messages.getString("Pan.Error.ProcessStopError", e.getMessage()));
            e.printStackTrace();
            Pan.exitJVM(1);
        }
        if (trans == null) {
            if (rep != null) {
                rep.disconnect();
            }
            if (!"Y".equalsIgnoreCase(optionListtrans.toString()) && !"Y".equalsIgnoreCase(optionListdir.toString()) && !"Y".equalsIgnoreCase(optionListrep.toString()) && Const.isEmpty((StringBuffer)optionExprep)) {
                System.out.println(Messages.getString("Pan.Error.CanNotLoadTrans"));
                Pan.exitJVM(7);
            } else {
                Pan.exitJVM(0);
            }
        }
        try {
            block91: {
                try {
                    String value;
                    String[] transParams;
                    trans.initializeVariablesFrom(null);
                    trans.getTransMeta().setInternalKettleVariables(trans);
                    for (String param : transParams = trans.listParameters()) {
                        value = optionParams.getParameterValue(param);
                        if (value == null) continue;
                        trans.setParameterValue(param, value);
                    }
                    trans.activateParameters();
                    if ("Y".equalsIgnoreCase(optionSafemode.toString())) {
                        trans.setSafeModeEnabled(true);
                    }
                    if ("Y".equalsIgnoreCase(optionListParam.toString())) {
                        for (String parameterName : trans.listParameters()) {
                            value = trans.getParameterValue(parameterName);
                            String deflt = trans.getParameterDefault(parameterName);
                            String descr = trans.getParameterDescription(parameterName);
                            if (deflt != null) {
                                System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + ", default=" + deflt + " : " + Const.NVL((String)descr, (String)""));
                                continue;
                            }
                            System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + " : " + Const.NVL((String)descr, (String)""));
                        }
                        Pan.exitJVM(7);
                    }
                    try {
                        trans.execute(args.toArray(new String[args.size()]));
                    }
                    catch (KettleException e) {
                        System.out.println(Messages.getString("Pan.Error.UnablePrepareInitTrans"));
                        Pan.exitJVM(3);
                    }
                    trans.waitUntilFinished();
                    trans.endProcessing("end");
                    log.logMinimal("Pan", Messages.getString("Pan.Log.Finished"), new Object[0]);
                    cal = Calendar.getInstance();
                    Date stop = cal.getTime();
                    String begin = df.format(start).toString();
                    String end = df.format(stop).toString();
                    log.logMinimal("Pan", Messages.getString("Pan.Log.StartStop", begin, end), new Object[0]);
                    long millis = stop.getTime() - start.getTime();
                    long seconds = millis / 1000L;
                    if (seconds <= 60L) {
                        log.logMinimal("Pan", Messages.getString("Pan.Log.ProcessingEndAfter", String.valueOf(seconds)), new Object[0]);
                    } else if (seconds <= 3600L) {
                        int min = (int)(seconds / 60L);
                        int rem = (int)(seconds % 60L);
                        log.logMinimal("Pan", Messages.getString("Pan.Log.ProcessingEndAfterLong", String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)), new Object[0]);
                    } else if (seconds <= 86400L) {
                        int hour = (int)(seconds / 3600L);
                        int rem = (int)(seconds % 3600L);
                        int min = rem / 60;
                        log.logMinimal("Pan", Messages.getString("Pan.Log.ProcessingEndAfterLonger", String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)), new Object[0]);
                    } else {
                        int days = (int)(seconds / 86400L);
                        int rem = (int)(seconds % 86400L);
                        int hour = rem / 3600;
                        int min = (rem %= 3600) / 60;
                        log.logMinimal("Pan", Messages.getString("Pan.Log.ProcessingEndAfterLongest", String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)), new Object[0]);
                    }
                    if (trans.getResult().getNrErrors() == 0L) {
                        trans.printStats((int)millis / 1000);
                        Pan.exitJVM(0);
                        break block91;
                    }
                    Pan.exitJVM(1);
                }
                catch (KettleException ke) {
                    System.out.println(Messages.getString("Pan.Log.ErrorOccurred", "" + ke.getMessage()));
                    log.logError("Pan", Messages.getString("Pan.Log.UnexpectedErrorOccurred", "" + ke.getMessage()), new Object[0]);
                    LogWriter.closeAndRemoveFileAppender();
                    Pan.exitJVM(2);
                    Object var47_71 = null;
                    if (rep != null) {
                        rep.disconnect();
                    }
                }
            }
            Object var47_70 = null;
            if (rep != null) {
                rep.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var47_72 = null;
            if (rep != null) {
                rep.disconnect();
            }
            throw throwable;
        }
    }

    private static final void exitJVM(int status) {
        LogWriter.getInstance().close();
        System.exit(status);
    }
}

