/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableInsert;
import org.hibernate.sql.model.ast.builder.AbstractTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;

public abstract class AbstractTableInsertBuilder
extends AbstractTableMutationBuilder<TableInsert>
implements TableInsertBuilder {
    private final List<ColumnValueBinding> keyBindingList = new ArrayList<ColumnValueBinding>();
    private final List<ColumnValueBinding> valueBindingList = new ArrayList<ColumnValueBinding>();
    private List<ColumnValueBinding> lobValueBindingList;
    private String sqlComment;

    public AbstractTableInsertBuilder(MutationTarget<?> mutationTarget, TableMapping table, SessionFactoryImplementor sessionFactory) {
        super(MutationType.INSERT, mutationTarget, table, sessionFactory);
        this.sqlComment = "insert for " + mutationTarget.getRolePath();
    }

    public AbstractTableInsertBuilder(MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory) {
        super(MutationType.INSERT, mutationTarget, tableReference, sessionFactory);
        this.sqlComment = "insert for " + mutationTarget.getRolePath();
    }

    public String getSqlComment() {
        return this.sqlComment;
    }

    public void setSqlComment(String sqlComment) {
        this.sqlComment = sqlComment;
    }

    protected List<ColumnValueBinding> getKeyBindingList() {
        return this.keyBindingList;
    }

    protected List<ColumnValueBinding> getValueBindingList() {
        return this.valueBindingList;
    }

    protected List<ColumnValueBinding> getLobValueBindingList() {
        return this.lobValueBindingList;
    }

    @Override
    public void addValueColumn(String columnWriteFragment, SelectableMapping selectableMapping) {
        ColumnValueBinding valueBinding = this.createValueBinding(columnWriteFragment, selectableMapping);
        if (selectableMapping.isLob() && this.getJdbcServices().getDialect().forceLobAsLastValue()) {
            if (this.lobValueBindingList == null) {
                this.lobValueBindingList = new ArrayList<ColumnValueBinding>();
            }
            this.lobValueBindingList.add(valueBinding);
        } else {
            this.valueBindingList.add(valueBinding);
        }
    }

    @Override
    public void addValueColumn(ColumnValueBinding valueBinding) {
        this.valueBindingList.add(valueBinding);
    }

    @Override
    public void addKeyColumn(String columnWriteFragment, SelectableMapping selectableMapping) {
        this.addColumn(columnWriteFragment, selectableMapping, this.keyBindingList);
    }
}

