/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l * i64vec2(-10l, -12l)) => i64vec2(0l, 0l)
 * (0l * i64vec2(-42l, 48l)) => i64vec2(0l, 0l)
 * (3l * i64vec2(-10l, -12l)) => i64vec2(-30l, -36l)
 * (3l * i64vec2(-42l, 48l)) => i64vec2(-126l, 144l)
 * (-1192l * i64vec2(-10l, -12l)) => i64vec2(11920l, 14304l)
 * (-1192l * i64vec2(-42l, 48l)) => i64vec2(50064l, -57216l)
 * (1048576l * i64vec2(-10l, -12l)) => i64vec2(-10485760l, -12582912l)
 * (1048576l * i64vec2(-42l, 48l)) => i64vec2(-44040192l, 50331648l)
 * (4251475l * i64vec2(-10l, -12l)) => i64vec2(-42514750l, -51017700l)
 * (4251475l * i64vec2(-42l, 48l)) => i64vec2(-178561950l, 204070800l)
 * (29852643761l * i64vec2(-10l, -12l)) => i64vec2(-298526437610l, -358231725132l)
 * (29852643761l * i64vec2(-42l, 48l)) => i64vec2(-1253811037962l, 1432926900528l)
 * (-4398046511104l * i64vec2(-10l, -12l)) => i64vec2(43980465111040l, 52776558133248l)
 * (-4398046511104l * i64vec2(-42l, 48l)) => i64vec2(184717953466368l, -211106232532992l)
 * (-3948976685146l * i64vec2(-10l, -12l)) => i64vec2(39489766851460l, 47387720221752l)
 * (-3948976685146l * i64vec2(-42l, 48l)) => i64vec2(165857020776132l, -189550880887008l)
 * (-135763469567146206l * i64vec2(-10l, -12l)) => i64vec2(1357634695671462060l, 1629161634805754472l)
 * (-135763469567146206l * i64vec2(-42l, 48l)) => i64vec2(5702065721820140652l, -6516646539223017888l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l * i64vec2(-10l, -12l)), i64vec2(0l, 0l))) ? 1 : -1] array0;
  float[all(equal((0l * i64vec2(-42l, 48l)), i64vec2(0l, 0l))) ? 1 : -1] array1;
  float[all(equal((3l * i64vec2(-10l, -12l)), i64vec2(-30l, -36l))) ? 1 : -1] array2;
  float[all(equal((3l * i64vec2(-42l, 48l)), i64vec2(-126l, 144l))) ? 1 : -1] array3;
  float[all(equal((-1192l * i64vec2(-10l, -12l)), i64vec2(11920l, 14304l))) ? 1 : -1] array4;
  float[all(equal((-1192l * i64vec2(-42l, 48l)), i64vec2(50064l, -57216l))) ? 1 : -1] array5;
  float[all(equal((1048576l * i64vec2(-10l, -12l)), i64vec2(-10485760l, -12582912l))) ? 1 : -1] array6;
  float[all(equal((1048576l * i64vec2(-42l, 48l)), i64vec2(-44040192l, 50331648l))) ? 1 : -1] array7;
  float[all(equal((4251475l * i64vec2(-10l, -12l)), i64vec2(-42514750l, -51017700l))) ? 1 : -1] array8;
  float[all(equal((4251475l * i64vec2(-42l, 48l)), i64vec2(-178561950l, 204070800l))) ? 1 : -1] array9;
  float[all(equal((29852643761l * i64vec2(-10l, -12l)), i64vec2(-298526437610l, -358231725132l))) ? 1 : -1] array10;
  float[all(equal((29852643761l * i64vec2(-42l, 48l)), i64vec2(-1253811037962l, 1432926900528l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l * i64vec2(-10l, -12l)), i64vec2(43980465111040l, 52776558133248l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l * i64vec2(-42l, 48l)), i64vec2(184717953466368l, -211106232532992l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l * i64vec2(-10l, -12l)), i64vec2(39489766851460l, 47387720221752l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l * i64vec2(-42l, 48l)), i64vec2(165857020776132l, -189550880887008l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l * i64vec2(-10l, -12l)), i64vec2(1357634695671462060l, 1629161634805754472l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l * i64vec2(-42l, 48l)), i64vec2(5702065721820140652l, -6516646539223017888l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
