# Contributing to AntiMicroX

We welcome and appreciate all contributions to this open source project!

## How to contribute

Before contributing, please take a moment to review the following guidelines:

1. Check the [issue tracker](https://github.com/AntiMicroX/antimicrox/issues) to see if the issue or feature you're interested in has already been reported or discussed.
2. If you would like to suggest a new feature, please [start a new issue](https://github.com/AntiMicroX/antimicrox/issues/new/choose) to discuss the proposal.
3. If you would like to contribute code, check the [project's coding guidelines](https://github.com/AntiMicroX/antimicrox/wiki/Coding-guidelines) and make sure your code is well-documented preferably in doxygen-compatible format.
4. Submit a pull request to the main repository for review. In case of preparing bigger changes into the codebase it is recommended to firstly open `Draft Pull Request` to show what you are going to do.

During coding you may find [AntiMicroX online docs](https://antimicrox.github.io/doxygen/) useful.

## Translation

Translation process is handled via [Weblate](https://weblate.org/). If you want to help just click this [link](https://hosted.weblate.org/engage/antimicrox).

Translation status

<a href="https://hosted.weblate.org/engage/antimicrox/">
<img src="https://hosted.weblate.org/widgets/antimicrox/-/gui/multi-auto.svg" alt="Translation status" />
</a>

More information about translating can be found [here](https://github.com/AntiMicroX/antimicrox/wiki/Translating-AntiMicroX).

## License

By contributing to this project, you agree to license your contributions under the GPL-3.0 license.
