# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.serialconsole import MicrosoftSerialConsoleClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-serialconsole
# USAGE
    python enable_serial_console_for_a_subscription.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MicrosoftSerialConsoleClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-00000-0000-0000-000000000000",
    )

    response = client.enable_console(
        default="default",
    )
    print(response)


# x-ms-original-file: specification/serialconsole/resource-manager/Microsoft.SerialConsole/stable/2018-05-01/examples/EnableConsoleExamples.json
if __name__ == "__main__":
    main()
