#!/usr/bin/env python3

import os, subprocess, shutil

assert os.getcwd() == '/home/jpakkane'

from glob import glob

def purge(fname: str) -> None:
    if not os.path.exists(fname):
        return
    if os.path.isdir(fname):
        shutil.rmtree(fname)
    os.unlink(fname)

def update() -> None:
    webdir = 'mesonweb'
    repodir = 'mesonwebbuild'
    docdir = os.path.join(repodir, 'docs')
    builddir = os.path.join(docdir, 'builddir')
    htmldir = os.path.join(builddir, 'Meson documentation-doc/html')
#    subprocess.check_call(['git', 'pull'], cwd=webdir)
    subprocess.check_call(['git', 'fetch', '-a'], cwd=repodir)
    subprocess.check_call(['git', 'reset', '--hard', 'origin/master'],
                          cwd=repodir)
    if os.path.isdir(htmldir):
        shutil.rmtree(htmldir)
    if os.path.isdir(builddir):
        shutil.rmtree(builddir)
    env = os.environ.copy()
    env['PATH'] = env['PATH'] + ':/home/jpakkane/.local/bin'
    subprocess.check_call(['../meson.py', '.', 'builddir'], cwd=docdir, env=env)
    subprocess.check_call(['ninja'], cwd=builddir)
    old_files = glob(os.path.join(webdir, '*'))
    for f in old_files:
        base = f[len(webdir)+1:]
        if base == 'CNAME' or base == 'favicon.png':
            continue
        subprocess.check_call(['git', 'rm', '-rf', base], cwd=webdir)
    assert os.path.isdir(webdir)
    new_entries = glob(os.path.join(htmldir, '*'))
    for e in new_entries:
        shutil.move(e, webdir)
    subprocess.check_call('git add *', shell=True, cwd=webdir)
    subprocess.check_call(['git', 'commit', '-a', '-m', 'Bleep. Bloop. I am a bot.'],
                          cwd=webdir)
    subprocess.check_call(['git', 'push'], cwd=webdir)
    shutil.rmtree(builddir)

if __name__ == '__main__':
    update()
