#
# -*- coding: utf-8 -*-
# Copyright 2022 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the sonic_l3_acls module
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class L3_aclsArgs(object):  # pylint: disable=R0903
    """The arg spec for the sonic_l3_acls module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        'config': {
            'elements': 'dict',
            'options': {
                'acls': {
                    'elements': 'dict',
                    'options': {
                        'name': {'required': True, 'type': 'str'},
                        'remark': {'type': 'str'},
                        'rules': {
                            'elements': 'dict',
                            'options': {
                                'action': {
                                    'choices': ['deny', 'discard', 'do-not-nat', 'permit', 'transit'],
                                    'type': 'str'
                                },
                                'destination': {
                                    'mutually_exclusive': [['any', 'host', 'prefix']],
                                    'options': {
                                        'any': {'type': 'bool'},
                                        'host': {'type': 'str'},
                                        'port_number': {
                                            'mutually_exclusive': [['eq', 'gt', 'lt', 'range']],
                                            'options': {
                                                'eq': {'type': 'int'},
                                                'gt': {'type': 'int'},
                                                'lt': {'type': 'int'},
                                                'range': {
                                                    'options': {
                                                        'begin': {'type': 'int'},
                                                        'end': {'type': 'int'}
                                                    },
                                                    'required_together': [['begin', 'end']],
                                                    'type': 'dict'
                                                }
                                            },
                                            'type': 'dict'
                                        },
                                        'prefix': {'type': 'str'}
                                    },
                                    'required_one_of': [['any', 'host', 'prefix']],
                                    'type': 'dict'
                                },
                                'dscp': {
                                    'mutually_exclusive': [[
                                        'value', 'af11', 'af12', 'af13', 'af21', 'af22', 'af23', 'af31', 'af32', 'af33',
                                        'cs1', 'cs2', 'cs3', 'cs4', 'cs5', 'cs6', 'cs7', 'default', 'ef', 'voice_admit'
                                    ]],
                                    'options': {
                                        'af11': {'type': 'bool'},
                                        'af12': {'type': 'bool'},
                                        'af13': {'type': 'bool'},
                                        'af21': {'type': 'bool'},
                                        'af22': {'type': 'bool'},
                                        'af23': {'type': 'bool'},
                                        'af31': {'type': 'bool'},
                                        'af32': {'type': 'bool'},
                                        'af33': {'type': 'bool'},
                                        'af41': {'type': 'bool'},
                                        'af42': {'type': 'bool'},
                                        'af43': {'type': 'bool'},
                                        'cs1': {'type': 'bool'},
                                        'cs2': {'type': 'bool'},
                                        'cs3': {'type': 'bool'},
                                        'cs4': {'type': 'bool'},
                                        'cs5': {'type': 'bool'},
                                        'cs6': {'type': 'bool'},
                                        'cs7': {'type': 'bool'},
                                        'default': {'type': 'bool'},
                                        'ef': {'type': 'bool'},
                                        'value': {'type': 'int'},
                                        'voice_admit': {'type': 'bool'}
                                    },
                                    'type': 'dict'
                                },
                                'protocol': {
                                    'mutually_exclusive': [['name', 'number']],
                                    'options': {
                                        'name': {
                                            'choices': ['ip', 'ipv6', 'icmp', 'icmpv6', 'tcp', 'udp'],
                                            'type': 'str'
                                        },
                                        'number': {'type': 'int'}
                                    },
                                    'required_one_of': [['name', 'number']],
                                    'type': 'dict'
                                },
                                'protocol_options': {
                                    'mutually_exclusive': [['icmp', 'icmpv6', 'tcp']],
                                    'options': {
                                        'icmp': {
                                            'options': {
                                                'code': {'type': 'int'},
                                                'type': {'type': 'int'}
                                            },
                                            'type': 'dict'
                                        },
                                        'icmpv6': {
                                            'options': {
                                                'code': {'type': 'int'},
                                                'type': {'type': 'int'}
                                            },
                                            'type': 'dict'
                                        },
                                        'tcp': {
                                            'mutually_exclusive': [
                                                ['established', 'ack', 'not_ack'],
                                                ['established', 'fin', 'not_fin'],
                                                ['established', 'psh', 'not_psh'],
                                                ['established', 'rst', 'not_rst'],
                                                ['established', 'syn', 'not_syn'],
                                                ['established', 'urg', 'not_urg']
                                            ],
                                            'options': {
                                                'ack': {'type': 'bool'},
                                                'established': {'type': 'bool'},
                                                'fin': {'type': 'bool'},
                                                'not_ack': {'type': 'bool'},
                                                'not_fin': {'type': 'bool'},
                                                'not_psh': {'type': 'bool'},
                                                'not_rst': {'type': 'bool'},
                                                'not_syn': {'type': 'bool'},
                                                'not_urg': {'type': 'bool'},
                                                'psh': {'type': 'bool'},
                                                'rst': {'type': 'bool'},
                                                'syn': {'type': 'bool'},
                                                'urg': {'type': 'bool'}
                                            },
                                            'type': 'dict'
                                        }
                                    },
                                    'type': 'dict'
                                },
                                'remark': {'type': 'str'},
                                'sequence_num': {'required': True, 'type': 'int'},
                                'source': {
                                    'mutually_exclusive': [['any', 'host', 'prefix']],
                                    'options': {
                                        'any': {'type': 'bool'},
                                        'host': {'type': 'str'},
                                        'port_number': {
                                            'mutually_exclusive': [['eq', 'gt', 'lt', 'range']],
                                            'options': {
                                                'eq': {'type': 'int'},
                                                'gt': {'type': 'int'},
                                                'lt': {'type': 'int'},
                                                'range': {
                                                    'options': {
                                                        'begin': {'type': 'int'},
                                                        'end': {'type': 'int'}
                                                    },
                                                    'required_together': [['begin', 'end']],
                                                    'type': 'dict'
                                                }
                                            },
                                            'type': 'dict'
                                        },
                                        'prefix': {'type': 'str'}
                                    },
                                    'required_one_of': [['any', 'host', 'prefix']],
                                    'type': 'dict'
                                },
                                'vlan_id': {'type': 'int'}
                            },
                            'required_together': [['action', 'protocol', 'source', 'destination']],
                            'type': 'list'
                        }
                    },
                    'type': 'list'
                },
                'address_family': {
                    'choices': ['ipv4', 'ipv6'],
                    'required': True,
                    'type': 'str'
                }
            },
            'type': 'list'
        },
        'state': {
            'choices': ['merged', 'replaced', 'overridden', 'deleted'],
            'default': 'merged',
            'type': 'str'
        }
    }  # pylint: disable=C0301
