/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.HWBColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HWBColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import org.w3c.dom.DOMException;

class HWBColorImpl
extends BaseColor
implements HWBColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue hue = null;
    private PrimitiveValue whiteness = null;
    private PrimitiveValue blackness = null;

    HWBColorImpl() {
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HWB;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        HWBColorImpl setfrom = (HWBColorImpl)color;
        this.hue = setfrom.getHue();
        this.whiteness = setfrom.getWhiteness();
        this.blackness = setfrom.getBlackness();
    }

    @Override
    public NumberValue component(String component) {
        NumberValue ret;
        switch (component) {
            case "h": {
                ret = HWBColorImpl.hueComponent((CSSTypedValue)((Object)this.getHue()));
                break;
            }
            case "w": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getWhiteness()), 1.0f);
                break;
            }
            case "b": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getBlackness()), 1.0f);
                break;
            }
            case "alpha": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.alpha), 100.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getHue();
            }
            case 2: {
                return this.getWhiteness();
            }
            case 3: {
                return this.getBlackness();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setHue(component);
                break;
            }
            case 2: {
                this.setWhiteness(component);
                break;
            }
            case 3: {
                this.setBlackness(component);
            }
        }
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue hue) {
        this.hue = HWBColorImpl.enforceHueComponent(hue);
    }

    @Override
    public PrimitiveValue getWhiteness() {
        return this.whiteness;
    }

    public void setWhiteness(PrimitiveValue whiteness) {
        this.whiteness = HWBColorImpl.enforcePcntComponent(whiteness);
    }

    @Override
    public PrimitiveValue getBlackness() {
        return this.blackness;
    }

    public void setBlackness(PrimitiveValue blackness) {
        this.blackness = HWBColorImpl.enforcePcntComponent(blackness);
    }

    @Override
    boolean hasPercentageComponent() {
        return this.whiteness != null && this.whiteness.getUnitType() == 2 || this.blackness != null && this.blackness.getUnitType() == 2;
    }

    @Override
    boolean hasConvertibleComponents() {
        return HWBColorImpl.isConvertibleComponent(this.getWhiteness()) && HWBColorImpl.isConvertibleComponent(this.getHue()) && HWBColorImpl.isConvertibleComponent(this.getBlackness());
    }

    @Override
    void setColorComponents(double[] hwb) {
        NumberValue h = NumberValue.createCSSNumberValue((short)80, (float)hwb[0]);
        h.setSubproperty(true);
        h.setAbsolutizedUnit();
        this.setHue(h);
        PercentageValue w = new PercentageValue();
        w.setFloatValue((short)2, (float)hwb[1]);
        w.setSubproperty(true);
        w.setAbsolutizedUnit();
        this.setWhiteness(w);
        PercentageValue b = new PercentageValue();
        b.setFloatValue((short)2, (float)hwb[2]);
        b.setSubproperty(true);
        b.setAbsolutizedUnit();
        this.setBlackness(b);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] hwb = new double[]{ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getWhiteness())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getBlackness()))};
        return hwb;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double hue = ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())) / 360.0;
        double whiteness = ColorUtil.fraction((CSSTypedValue)((Object)this.getWhiteness()));
        double blackness = ColorUtil.fraction((CSSTypedValue)((Object)this.getBlackness()));
        double[] rgb = new double[3];
        this.hwbToSRGB(hue, whiteness, blackness, rgb);
        return rgb;
    }

    private void hwbToSRGB(double hue, double whiteness, double blackness, double[] rgb) {
        if (hue > 1.0) {
            hue -= Math.floor(hue);
        } else if (hue < 0.0) {
            hue = hue - Math.floor(hue) + 1.0;
        }
        double fh = Math.floor(hue *= 6.0);
        double f = hue - fh;
        int ifh = (int)fh;
        if (ifh % 2 == 1) {
            f = 1.0 - f;
        }
        double value = 1.0 - blackness;
        double wv = whiteness + f * (value - whiteness);
        switch (ifh) {
            case 1: {
                rgb[0] = wv;
                rgb[1] = value;
                rgb[2] = whiteness;
                break;
            }
            case 2: {
                rgb[0] = whiteness;
                rgb[1] = value;
                rgb[2] = wv;
                break;
            }
            case 3: {
                rgb[0] = whiteness;
                rgb[1] = wv;
                rgb[2] = value;
                break;
            }
            case 4: {
                rgb[0] = wv;
                rgb[1] = whiteness;
                rgb[2] = value;
                break;
            }
            case 5: {
                rgb[0] = value;
                rgb[1] = whiteness;
                rgb[2] = wv;
                break;
            }
            default: {
                rgb[0] = value;
                rgb[1] = wv;
                rgb[2] = whiteness;
            }
        }
    }

    @Override
    public String toString() {
        boolean nonOpaque = this.isNonOpaque();
        StringBuilder buf = new StringBuilder(20);
        buf.append("hwb(");
        this.appendHue(buf, this.hue);
        buf.append(' ').append(this.whiteness.getCssText()).append(' ').append(this.blackness.getCssText());
        if (nonOpaque) {
            buf.append(" / ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String toMinifiedString() {
        boolean nonOpaque = this.isNonOpaque();
        StringBuilder buf = new StringBuilder(20);
        buf.append("hwb(");
        this.appendMinifiedHue(buf, this.hue);
        buf.append(' ').append(this.whiteness.getMinifiedCssText("color")).append(' ').append(this.blackness.getMinifiedCssText("color"));
        if (nonOpaque) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blackness == null ? 0 : this.blackness.hashCode());
        result = 31 * result + (this.hue == null ? 0 : this.hue.hashCode());
        result = 31 * result + (this.whiteness == null ? 0 : this.whiteness.hashCode());
        result = 31 * result + this.alpha.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HWBColorImpl other = (HWBColorImpl)obj;
        if (this.blackness == null ? other.blackness != null : !this.blackness.equals(other.blackness)) {
            return false;
        }
        if (this.hue == null ? other.hue != null : !this.hue.equals(other.hue)) {
            return false;
        }
        if (this.whiteness == null ? other.whiteness != null : !this.whiteness.equals(other.whiteness)) {
            return false;
        }
        return this.alpha.equals(other.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new HWBColorValue(this);
    }

    @Override
    public HWBColorImpl clone() {
        HWBColorImpl clon = new HWBColorImpl();
        clon.alpha = this.alpha.clone();
        if (this.hue != null) {
            clon.hue = this.hue.clone();
        }
        if (this.whiteness != null) {
            clon.whiteness = this.whiteness.clone();
        }
        if (this.blackness != null) {
            clon.blackness = this.blackness.clone();
        }
        return clon;
    }
}

