/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.SafeCaller;
import org.openhab.core.common.SafeCallerBuilder;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.internal.common.SafeCallManagerImpl;
import org.openhab.core.internal.common.SafeCallerBuilderImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@NonNullByDefault
@Component(configurationPid={"org.openhab.safecaller"}, immediate=true)
public class SafeCallerImpl
implements SafeCaller {
    private static final String SAFE_CALL_POOL_NAME = "safeCall";
    private final ScheduledExecutorService watcher = Executors.newSingleThreadScheduledExecutor();
    private final SafeCallManagerImpl manager = new SafeCallManagerImpl(this.watcher, this.getScheduler(), false);

    @Activate
    public SafeCallerImpl(@Nullable Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    public void modified(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            String enabled = (String)properties.get("singleThread");
            this.manager.setEnforceSingleThreadPerIdentifier("true".equalsIgnoreCase(enabled));
        }
    }

    @Deactivate
    public void deactivate() {
        this.watcher.shutdownNow();
    }

    @Override
    public <T> SafeCallerBuilder<@NonNull T> create(T target, Class<T> interfaceType) {
        return new SafeCallerBuilderImpl<T>(target, new Class[]{interfaceType}, this.manager);
    }

    protected ExecutorService getScheduler() {
        return ThreadPoolManager.getPool(SAFE_CALL_POOL_NAME);
    }
}

