/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.DefaultAnimatorImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import jogamp.opengl.Debug;
import jogamp.opengl.FPSCounterImpl;

public abstract class AnimatorBase
implements GLAnimatorControl {
    protected static final boolean DEBUG = Debug.debug("Animator");
    protected static final long TO_WAIT_FOR_FINISH_LIFECYCLE_ACTION = 1000L;
    protected static final long POLLP_WAIT_FOR_FINISH_LIFECYCLE_ACTION = 32L;
    public static final int MODE_EXPECT_AWT_RENDERING_THREAD = 1;
    private static int seqInstanceNumber = 0;
    protected int modeBits;
    protected AnimatorImpl impl;
    protected String baseName;
    protected ArrayList<GLAutoDrawable> drawables = new ArrayList();
    protected boolean drawablesEmpty;
    protected Thread animThread;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;
    protected boolean exclusiveContext;
    protected Thread userExclusiveContextThread;
    protected GLAnimatorControl.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected FPSCounterImpl fpsCounter = new FPSCounterImpl();
    private static final Class<?> awtAnimatorImplClazz;
    private final Condition waitForNotAnimatingIfEmptyCondition = new Condition(){

        @Override
        public boolean eval() {
            return AnimatorBase.this.isStarted() && AnimatorBase.this.drawablesEmpty && AnimatorBase.this.isAnimating();
        }
    };

    public AnimatorBase() {
        this(1);
    }

    public AnimatorBase(int n) {
        this.modeBits = n;
        this.drawablesEmpty = true;
    }

    private static final boolean useAWTAnimatorImpl(int n) {
        return 0 != (1 & n) && null != awtAnimatorImplClazz;
    }

    protected final synchronized void initImpl(boolean bl) {
        if (bl || null == this.impl) {
            String string = String.format((Locale)null, "#%02d", seqInstanceNumber++);
            if (AnimatorBase.useAWTAnimatorImpl(this.modeBits)) {
                try {
                    this.impl = (AnimatorImpl)awtAnimatorImplClazz.newInstance();
                    this.baseName = this.getBaseName("AWT") + string;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null == this.impl) {
                this.impl = new DefaultAnimatorImpl();
                this.baseName = this.getBaseName("") + string;
            }
            if (DEBUG) {
                System.err.println("Animator.initImpl: baseName " + this.baseName + ", implClazz " + this.impl.getClass().getName() + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
            }
        }
    }

    protected abstract String getBaseName(String var1);

    public final synchronized void setModeBits(boolean bl, int n) throws GLException {
        int n2 = this.modeBits;
        this.modeBits = bl ? (this.modeBits |= n) : (this.modeBits &= ~n);
        if (AnimatorBase.useAWTAnimatorImpl(n2) != AnimatorBase.useAWTAnimatorImpl(this.modeBits)) {
            if (this.isStarted()) {
                throw new GLException("Animator already started");
            }
            this.initImpl(true);
        }
    }

    public synchronized int getModeBits() {
        return this.modeBits;
    }

    @Override
    public final synchronized void add(final GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator add: 0x" + Integer.toHexString(gLAutoDrawable.hashCode()) + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
        }
        if (this.drawables.contains(gLAutoDrawable)) {
            throw new IllegalArgumentException("Drawable already added to animator: " + this + ", " + gLAutoDrawable);
        }
        this.initImpl(false);
        this.pause();
        if (this.isStarted()) {
            gLAutoDrawable.setExclusiveContextThread(this.exclusiveContext ? this.getExclusiveContextThread() : null);
        }
        this.drawables.add(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(this);
        if (this.isPaused()) {
            this.resume();
        }
        Condition condition = new Condition(){

            @Override
            public boolean eval() {
                Thread thread = gLAutoDrawable.getExclusiveContextThread();
                return AnimatorBase.this.isStarted() && !AnimatorBase.this.isPaused() && !AnimatorBase.this.isAnimating() && (AnimatorBase.this.exclusiveContext && null == thread || !AnimatorBase.this.exclusiveContext && null != thread);
            }
        };
        boolean bl = this.finishLifecycleAction(condition, 0L);
        if (DEBUG) {
            System.err.println("Animator add: Wait for Animating/ECT OK: " + bl + ", " + this.toString() + ", dect " + gLAutoDrawable.getExclusiveContextThread());
        }
        this.notifyAll();
    }

    @Override
    public final synchronized void remove(final GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        if (DEBUG) {
            System.err.println("Animator remove: 0x" + Integer.toHexString(gLAutoDrawable.hashCode()) + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
        }
        if (!this.drawables.contains(gLAutoDrawable)) {
            throw new IllegalArgumentException("Drawable not added to animator: " + this + ", " + gLAutoDrawable);
        }
        if (this.exclusiveContext && this.isAnimating()) {
            gLAutoDrawable.setExclusiveContextThread(null);
            Condition condition = new Condition(){

                @Override
                public boolean eval() {
                    return null != gLAutoDrawable.getExclusiveContextThread();
                }
            };
            bl = this.finishLifecycleAction(condition, 32L);
            if (DEBUG) {
                System.err.println("Animator remove: Wait for Null-ECT OK: " + bl + ", " + this.toString() + ", dect " + gLAutoDrawable.getExclusiveContextThread());
            }
        }
        boolean bl2 = this.pause();
        this.drawables.remove(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(null);
        if (bl2) {
            this.resume();
        }
        bl = this.finishLifecycleAction(this.waitForNotAnimatingIfEmptyCondition, 0L);
        if (DEBUG) {
            System.err.println("Animator remove: Wait for !Animating-if-empty OK: " + bl + ", " + this.toString());
        }
        this.notifyAll();
    }

    public final synchronized Thread setExclusiveContext(Thread thread) {
        boolean bl = null != thread;
        Thread thread2 = this.userExclusiveContextThread;
        if (bl && thread != this.animThread) {
            this.userExclusiveContextThread = thread;
        }
        this.setExclusiveContext(bl);
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setExclusiveContext(boolean bl) {
        boolean bl2;
        Thread thread;
        boolean bl3;
        AnimatorBase animatorBase = this;
        synchronized (animatorBase) {
            bl3 = this.isStarted() && !this.drawablesEmpty;
            thread = this.userExclusiveContextThread;
            bl2 = this.exclusiveContext;
            this.exclusiveContext = bl;
            if (DEBUG) {
                System.err.println("AnimatorBase.setExclusiveContextThread: " + bl2 + " -> " + this.exclusiveContext + ", propagateState " + bl3 + ", " + this);
            }
        }
        animatorBase = bl ? (null != thread ? thread : this.animThread) : null;
        UncaughtAnimatorException uncaughtAnimatorException = null;
        if (bl3) {
            this.setDrawablesExclCtxState(bl);
            if (!bl) {
                if (Thread.currentThread() == this.getThread() || Thread.currentThread() == thread) {
                    try {
                        this.display();
                    }
                    catch (UncaughtAnimatorException uncaughtAnimatorException2) {
                        uncaughtAnimatorException = uncaughtAnimatorException2;
                    }
                } else {
                    boolean bl4 = this.isAnimating() ? false : this.resume();
                    for (int i = 10; 0 < i && this.isAnimating() && !this.validateDrawablesExclCtxState((Thread)((Object)animatorBase)); --i) {
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (bl4) {
                        this.pause();
                    }
                }
                AnimatorBase animatorBase2 = this;
                synchronized (animatorBase2) {
                    this.userExclusiveContextThread = null;
                }
            }
        }
        if (DEBUG) {
            System.err.println("AnimatorBase.setExclusiveContextThread: all-GLAD Ok: " + this.validateDrawablesExclCtxState((Thread)((Object)animatorBase)) + ", " + this);
            if (null != uncaughtAnimatorException) {
                System.err.println("AnimatorBase.setExclusiveContextThread: caught: " + uncaughtAnimatorException.getMessage());
                uncaughtAnimatorException.printStackTrace();
            }
        }
        if (null != uncaughtAnimatorException) {
            throw uncaughtAnimatorException;
        }
        return bl2;
    }

    public final synchronized boolean isExclusiveContextEnabled() {
        return this.exclusiveContext;
    }

    public final synchronized Thread getExclusiveContextThread() {
        return this.isStarted() && this.exclusiveContext ? (null != this.userExclusiveContextThread ? this.userExclusiveContextThread : this.animThread) : null;
    }

    protected final synchronized void setDrawablesExclCtxState(boolean bl) {
        if (DEBUG) {
            System.err.println("AnimatorBase.setExclusiveContextImpl exlusive " + this.exclusiveContext + ": Enable " + bl + " for " + this + " - " + Thread.currentThread());
        }
        Thread thread = this.getExclusiveContextThread();
        for (int i = 0; i < this.drawables.size(); ++i) {
            try {
                this.drawables.get(i).setExclusiveContextThread(bl ? thread : null);
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    protected final boolean validateDrawablesExclCtxState(Thread thread) {
        for (int i = 0; i < this.drawables.size(); ++i) {
            if (thread == this.drawables.get(i).getExclusiveContextThread()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final synchronized Thread getThread() {
        return this.animThread;
    }

    protected final void display() throws UncaughtAnimatorException {
        this.impl.display(this.drawables, this.ignoreExceptions, this.printExceptions);
        this.fpsCounter.tickFPS();
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    public final void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public final void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    @Override
    public final GLAnimatorControl.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    @Override
    public final void setUncaughtExceptionHandler(GLAnimatorControl.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    protected final synchronized boolean handleUncaughtException(UncaughtAnimatorException uncaughtAnimatorException) {
        if (null != this.uncaughtExceptionHandler) {
            try {
                this.uncaughtExceptionHandler.uncaughtException(this, uncaughtAnimatorException.getGLAutoDrawable(), uncaughtAnimatorException.getCause());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    protected final void flushGLRunnables() {
        for (int i = 0; i < this.drawables.size(); ++i) {
            this.drawables.get(i).flushGLRunnables();
        }
    }

    protected final synchronized boolean finishLifecycleAction(Condition condition, long l) {
        boolean bl;
        boolean bl2;
        long l2;
        boolean bl3;
        this.initImpl(false);
        if (this.impl.blockUntilDone(this.animThread)) {
            bl3 = true;
            l2 = 1000L;
            if (0L >= l) {
                l = l2;
            }
            bl2 = condition.eval();
            while (bl2 && l2 > 0L) {
                long l3 = System.currentTimeMillis();
                if (l > l2) {
                    l = l2;
                }
                this.notifyAll();
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                l2 -= System.currentTimeMillis() - l3;
                bl2 = condition.eval();
            }
        } else {
            bl3 = false;
            l2 = 0L;
            bl2 = condition.eval();
            if (bl2) {
                this.notifyAll();
                bl2 = condition.eval();
            }
        }
        boolean bl4 = bl = !bl2 || !bl3;
        if (DEBUG || bl3 && bl2) {
            if (bl3 && l2 <= 0L && bl2) {
                System.err.println("finishLifecycleAction(" + condition.getClass().getName() + "): ++++++ timeout reached ++++++ " + AnimatorBase.getThreadName());
            }
            System.err.println("finishLifecycleAction(" + condition.getClass().getName() + "): OK " + !bl2 + "- pollPeriod " + l + ", blocking " + bl3 + " -> res " + bl + ", waited " + (bl3 ? 1000L - l2 : 0L) + "/" + 1000L + " - " + AnimatorBase.getThreadName());
            System.err.println(" - " + this.toString());
            if (bl2) {
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
        }
        return bl;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.animThread != null;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        return this.getClass().getName() + "[started " + this.isStarted() + ", animating " + this.isAnimating() + ", paused " + this.isPaused() + ", drawable " + this.drawables.size() + ", totals[dt " + this.getTotalFPSDuration() + ", frames " + this.getTotalFPSFrames() + ", fps " + this.getTotalFPS() + "], modeBits " + this.modeBits + ", init'ed " + (null != this.impl) + ", animThread " + this.getThread() + ", exclCtxThread " + this.exclusiveContext + "(" + this.getExclusiveContextThread() + ")]";
    }

    static {
        GLProfile.initSingleton();
        if (GLProfile.isAWTAvailable()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.jogamp.opengl.util.AWTAnimatorImpl");
            }
            catch (Exception exception) {
                clazz = null;
            }
            awtAnimatorImplClazz = clazz;
        } else {
            awtAnimatorImplClazz = null;
        }
    }

    protected static interface Condition {
        public boolean eval();
    }

    public static interface AnimatorImpl {
        public void display(ArrayList<GLAutoDrawable> var1, boolean var2, boolean var3) throws UncaughtAnimatorException;

        public boolean blockUntilDone(Thread var1);
    }

    public static class UncaughtAnimatorException
    extends RuntimeException {
        final GLAutoDrawable drawable;

        public UncaughtAnimatorException(GLAutoDrawable gLAutoDrawable, Throwable throwable) {
            super(throwable);
            this.drawable = gLAutoDrawable;
        }

        public final GLAutoDrawable getGLAutoDrawable() {
            return this.drawable;
        }
    }
}

