/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.vertx.http.security.AuthorizationPolicy;
import java.util.Collection;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class HttpSecurityUtils {
    static final DotName AUTHORIZATION_POLICY = DotName.createSimple(AuthorizationPolicy.class);

    private HttpSecurityUtils() {
    }

    public static boolean hasAuthorizationPolicyAnnotation(MethodInfo methodInfo) {
        return HttpSecurityUtils.findAuthorizationPolicyAnnotation(methodInfo.annotations()).isPresent();
    }

    public static boolean hasAuthorizationPolicyAnnotation(ClassInfo classInfo) {
        return HttpSecurityUtils.findAuthorizationPolicyAnnotation(classInfo.declaredAnnotations()).isPresent();
    }

    public static boolean hasSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.hasSecurityAnnotation((MethodInfo)methodInfo) || HttpSecurityUtils.hasAuthorizationPolicyAnnotation(methodInfo);
    }

    public static boolean hasSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo) || HttpSecurityUtils.hasAuthorizationPolicyAnnotation(classInfo);
    }

    static Optional<AnnotationInstance> findAuthorizationPolicyAnnotation(Collection<AnnotationInstance> instances) {
        return instances.stream().filter(ai -> ai.name().equals((Object)AUTHORIZATION_POLICY)).findFirst();
    }
}

