/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.models.AbstractConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class ParConfig
extends AbstractConfig {
    public static final String PAR_REQUEST_URI_LIFESPAN = "parRequestUriLifespan";
    public static final int DEFAULT_PAR_REQUEST_URI_LIFESPAN = 60;
    private int requestUriLifespan;
    public static final String REQUIRE_PUSHED_AUTHORIZATION_REQUESTS = "require.pushed.authorization.requests";

    public ParConfig(RealmModel realm) {
        this.requestUriLifespan = realm.getAttribute(PAR_REQUEST_URI_LIFESPAN, 60);
        this.realmForWrite = () -> realm;
    }

    public int getRequestUriLifespan() {
        return this.requestUriLifespan;
    }

    public void setRequestUriLifespan(String requestUriLifespan) {
        if (requestUriLifespan == null) {
            this.setRequestUriLifespan((Integer)null);
        } else {
            this.setRequestUriLifespan(Integer.parseInt(requestUriLifespan));
        }
    }

    public void setRequestUriLifespan(Integer requestUriLifespan) {
        if (requestUriLifespan == null) {
            requestUriLifespan = 60;
        }
        this.requestUriLifespan = requestUriLifespan;
        this.persistRealmAttribute(PAR_REQUEST_URI_LIFESPAN, requestUriLifespan);
    }

    public boolean isRequirePushedAuthorizationRequests(ClientModel client) {
        String enabled = client.getAttribute(REQUIRE_PUSHED_AUTHORIZATION_REQUESTS);
        return Boolean.parseBoolean(enabled);
    }
}

