/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile.event;

import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;

public class ProfileChangeEvent
extends EventObject {
    final List<ProfileResult> profileResultList;

    public ProfileChangeEvent(ProfileManager source, List<? extends ProfileResult> prList) {
        super(source);
        this.profileResultList = Collections.unmodifiableList(new ArrayList<ProfileResult>(prList));
    }

    public List<ProfileResult> getProfileResults() {
        return this.profileResultList;
    }

    @Override
    public ProfileManager getSource() {
        return (ProfileManager)super.getSource();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProfileChangeEvent(source = ").append(this.source);
        for (ProfileResult pr : this.profileResultList) {
            Object profiledObject = pr.getProfiledObject();
            String name = profiledObject != null ? profiledObject.getName() : "unknown profiled object";
            buf.append(String.format(" [%s, %s]", name, pr));
        }
        buf.append(" )");
        return buf.toString();
    }
}

