/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util.reservoir;

import ca.sqlpower.util.reservoir.Reservoir;
import ca.sqlpower.util.reservoir.ReservoirDataException;
import ca.sqlpower.util.reservoir.ReservoirDataSource;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;

public class BasicReservoir<T>
implements Reservoir<T> {
    Random r = new Random();

    @Override
    public T[] getSample(ReservoirDataSource<T> dataSource, int n) throws ReservoirDataException {
        if (n == 0) {
            return this.makeArray(dataSource.getElementType(), 0);
        }
        ArrayList<T> C = new ArrayList<T>(n);
        for (int j = 0; j < n && dataSource.hasNext(); ++j) {
            C.add(dataSource.readNextRecord());
        }
        int t = n;
        while (dataSource.hasNext()) {
            int m;
            if ((m = (int)((double)(++t) * this.r.nextDouble())) < n) {
                C.set(m, dataSource.readNextRecord());
                continue;
            }
            dataSource.skipRecords(1);
        }
        return C.toArray(this.makeArray(dataSource.getElementType(), C.size()));
    }

    @Override
    public void setRandomSeed(long s) {
        this.r.setSeed(s);
    }

    private T[] makeArray(Class<T> elemType, int size) {
        return (Object[])Array.newInstance(elemType, size);
    }
}

