/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.AnnotationSetItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetRefListItem;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import java.util.Map;

public class AnnotationsDirectoryItem
extends BaseItem {
    public AnnotationSetItem classAnnotations;
    public Map<FieldIdItem, AnnotationSetItem> fieldAnnotations;
    public Map<MethodIdItem, AnnotationSetItem> methodAnnotations;
    public Map<MethodIdItem, AnnotationSetRefListItem> parameterAnnotations;

    @Override
    public int place(int offset) {
        offset += 16;
        if (this.fieldAnnotations != null) {
            offset += this.fieldAnnotations.size() * 8;
        }
        if (this.methodAnnotations != null) {
            offset += this.methodAnnotations.size() * 8;
        }
        if (this.parameterAnnotations != null) {
            offset += this.parameterAnnotations.size() * 8;
        }
        return offset;
    }

    @Override
    public void write(DataOut out) {
        out.uint("class_annotations_off", this.classAnnotations == null ? 0 : this.classAnnotations.offset);
        out.uint("fields_size", this.fieldAnnotations == null ? 0 : this.fieldAnnotations.size());
        out.uint("annotated_methods_size", this.methodAnnotations == null ? 0 : this.methodAnnotations.size());
        out.uint("annotated_parameter_size", this.parameterAnnotations == null ? 0 : this.parameterAnnotations.size());
        if (this.fieldAnnotations != null) {
            for (Map.Entry<BaseItem, AnnotationSetItem> entry : this.fieldAnnotations.entrySet()) {
                out.uint("field_idx", ((FieldIdItem)entry.getKey()).index);
                out.uint("annotations_off", entry.getValue().offset);
            }
        }
        if (this.methodAnnotations != null) {
            for (Map.Entry<BaseItem, BaseItem> entry : this.methodAnnotations.entrySet()) {
                out.uint("method_idx", ((MethodIdItem)entry.getKey()).index);
                out.uint("annotations_off", ((AnnotationSetItem)entry.getValue()).offset);
            }
        }
        if (this.parameterAnnotations != null) {
            for (Map.Entry<BaseItem, BaseItem> entry : this.parameterAnnotations.entrySet()) {
                out.uint("method_idx", ((MethodIdItem)entry.getKey()).index);
                out.uint("annotations_off", ((AnnotationSetRefListItem)entry.getValue()).offset);
            }
        }
    }
}

