/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.GLXFBConfig;
import com.sun.opengl.impl.x11.X11GLContext;
import com.sun.opengl.impl.x11.X11GLDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11ExternalGLDrawable
extends X11GLDrawable {
    private int fbConfigID;
    private int renderType;
    private int screen;
    private long readDrawable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11ExternalGLDrawable() {
        super(null, null);
        this.lockToolkit();
        try {
            this.display = GLX.glXGetCurrentDisplay();
            this.drawable = GLX.glXGetCurrentDrawable();
            this.readDrawable = GLX.glXGetCurrentReadDrawable();
            if (this.drawable == 0L) {
                throw new GLException("Error: attempted to make an external GLDrawable without a drawable/context current");
            }
            long l = GLX.glXGetCurrentContext();
            int[] nArray = new int[1];
            GLX.glXQueryContext(this.display, l, 32787, nArray, 0);
            this.fbConfigID = nArray[0];
            this.renderType = 32788;
            GLX.glXQueryContext(this.display, l, 32785, nArray, 0);
            if ((nArray[0] & 1) == 0 && DEBUG) {
                System.err.println("X11ExternalGLDrawable: WARNING: forcing GLX_RGBA_TYPE for newly created contexts");
            }
            GLX.glXQueryContext(this.display, l, 32780, nArray, 0);
            this.screen = nArray[0];
        }
        finally {
            this.unlockToolkit();
        }
    }

    public GLContext createContext(GLContext gLContext) {
        return new Context(gLContext);
    }

    public void setSize(int n, int n2) {
        throw new GLException("Should not call this");
    }

    public int getWidth() {
        throw new GLException("Should not call this");
    }

    public int getHeight() {
        throw new GLException("Should not call this");
    }

    public void destroy() {
    }

    class Context
    extends X11GLContext {
        Context(GLContext gLContext) {
            super(X11ExternalGLDrawable.this, gLContext);
            this.drawable = this.drawable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int makeCurrentImpl() throws GLException {
            if (this.drawable.getDrawable() == 0L) {
                if (DEBUG) {
                    System.err.println("parent drawable not properly initialized");
                }
                return 0;
            }
            this.lockToolkit();
            try {
                boolean bl = false;
                if (this.context == 0L) {
                    this.create();
                    if (DEBUG) {
                        System.err.println(Context.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
                    }
                    bl = true;
                }
                if (!GLX.glXMakeContextCurrent(this.drawable.getDisplay(), this.drawable.getDrawable(), X11ExternalGLDrawable.this.readDrawable, this.context)) {
                    throw new GLException("Error making context current");
                }
                this.mostRecentDisplay = this.drawable.getDisplay();
                if (DEBUG && VERBOSE) {
                    System.err.println(Context.getThreadName() + ": glXMakeCurrent(display " + Context.toHexString(this.drawable.getDisplay()) + ", drawable " + Context.toHexString(this.drawable.getDrawable()) + ", context " + Context.toHexString(this.context) + ") succeeded");
                }
                if (bl) {
                    this.resetGLFunctionAvailability();
                    int n = 2;
                    return n;
                }
                int n = 1;
                return n;
            }
            finally {
                this.unlockToolkit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseImpl() throws GLException {
            this.lockToolkit();
            try {
                if (!GLX.glXMakeContextCurrent(this.drawable.getDisplay(), 0L, 0L, 0L)) {
                    throw new GLException("Error freeing OpenGL context");
                }
            }
            finally {
                this.unlockToolkit();
            }
        }

        protected void create() {
            int[] nArray = new int[]{32787, X11ExternalGLDrawable.this.fbConfigID, 0, 0};
            float[] fArray = new float[]{};
            int[] nArray2 = new int[1];
            GLXFBConfig[] gLXFBConfigArray = GLX.glXChooseFBConfig(X11ExternalGLDrawable.this.display, X11ExternalGLDrawable.this.screen, nArray, 0, nArray2, 0);
            int n = nArray2[0];
            if (n <= 0) {
                throw new GLException("context creation error: couldn't find a suitable frame buffer configuration");
            }
            if (n != 1) {
                throw new GLException("context creation error: shouldn't get more than one GLXFBConfig");
            }
            GLXFBConfig gLXFBConfig = gLXFBConfigArray[0];
            X11GLContext x11GLContext = (X11GLContext)GLContextShareSet.getShareContext(this);
            long l = 0L;
            if (x11GLContext != null && (l = x11GLContext.getContext()) == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            this.context = GLX.glXCreateNewContext(X11ExternalGLDrawable.this.display, gLXFBConfig, X11ExternalGLDrawable.this.renderType, l, true);
            if (this.context == 0L) {
                String string = "  display=" + Context.toHexString(X11ExternalGLDrawable.this.display) + " fbconfig=" + gLXFBConfig + " fbconfigID=" + Context.toHexString(X11ExternalGLDrawable.this.fbConfigID) + " renderType=" + Context.toHexString(X11ExternalGLDrawable.this.renderType) + " share=" + Context.toHexString(l);
                throw new GLException("context creation error: glXCreateNewContext() failed: " + string);
            }
            GLContextShareSet.contextCreated(this);
            if (DEBUG) {
                System.err.println("Created context " + Context.toHexString(this.context) + " for GLXDrawable " + Context.toHexString(this.drawable.getDrawable()));
            }
        }
    }
}

