/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.PdfFont;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRPdfExporter
extends JRAbstractExporter {
    public static final String PDF_FORCE_SVG_SHAPES = "net.sf.jasperreports.export.pdf.force.svg.shapes";
    private static final String PDF_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.pdf.exclude.origin.";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered = false;
    protected Document document = null;
    protected PdfContentByte pdfContentByte = null;
    protected PdfWriter pdfWriter = null;
    protected Document imageTesterDocument = null;
    protected PdfContentByte imageTesterPdfContentByte = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected boolean forceSvgShapes;
    protected boolean isCreatingBatchModeBookmarks;
    protected boolean isCompressed;
    protected boolean isEncrypted;
    protected boolean is128BitKey;
    protected String userPassword;
    protected String ownerPassword;
    protected int permissions = 0;
    protected Character pdfVersion;
    protected String pdfJavaScript;
    protected Map loadedImagesMap = null;
    protected Image pxImage = null;
    private BookmarkStack bookmarkStack = null;
    private Map fontMap = null;
    private SplitCharacter splitCharacter;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance((byte[])JRLoader.loadBytesFromLocation("net/sf/jasperreports/engine/images/pixel.GIF", null));
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block20: {
            JRPdfExporter.registerFonts();
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                String strPdfVersion;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), PDF_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.isCreatingBatchModeBookmarks = this.getBooleanParameter(JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, "net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", false);
                this.forceSvgShapes = this.getBooleanParameter(JRPdfExporterParameter.FORCE_SVG_SHAPES, PDF_FORCE_SVG_SHAPES, false);
                this.isCompressed = this.getBooleanParameter(JRPdfExporterParameter.IS_COMPRESSED, "net.sf.jasperreports.export.pdf.compressed", false);
                this.isEncrypted = this.getBooleanParameter(JRPdfExporterParameter.IS_ENCRYPTED, "net.sf.jasperreports.export.pdf.encrypted", false);
                this.is128BitKey = this.getBooleanParameter(JRPdfExporterParameter.IS_128_BIT_KEY, "net.sf.jasperreports.export.pdf.128.bit.key", false);
                this.userPassword = this.getStringParameter(JRPdfExporterParameter.USER_PASSWORD, "net.sf.jasperreports.export.pdf.user.password");
                this.ownerPassword = this.getStringParameter(JRPdfExporterParameter.OWNER_PASSWORD, "net.sf.jasperreports.export.pdf.owner.password");
                Integer permissionsParameter = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
                if (permissionsParameter != null) {
                    this.permissions = permissionsParameter;
                }
                this.pdfVersion = (strPdfVersion = this.getStringParameter(JRPdfExporterParameter.PDF_VERSION, "net.sf.jasperreports.export.pdf.version")) == null || strPdfVersion.length() == 0 ? null : new Character(strPdfVersion.charAt(0));
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setSplitCharacter();
                this.setHyperlinkProducerFactory();
                this.pdfJavaScript = this.getStringParameter(JRPdfExporterParameter.PDF_JAVASCRIPT, "net.sf.jasperreports.export.pdf.javascript");
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block20;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setSplitCharacter() {
        Boolean useFillSplitCharacterParam = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_LINEBREAK_POLICY);
        boolean useFillSplitCharacter = useFillSplitCharacterParam == null ? JRProperties.getBooleanProperty(this.jasperPrint.getPropertiesMap(), "net.sf.jasperreports.export.pdf.force.linebreak.policy", false) : useFillSplitCharacterParam;
        if (useFillSplitCharacter) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean closeDocuments = true;
        try {
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            this.pdfWriter.setCloseStream(false);
            if (this.pdfVersion != null) {
                this.pdfWriter.setPdfVersion(this.pdfVersion.charValue());
            }
            if (this.isCompressed) {
                this.pdfWriter.setFullCompression();
            }
            if (this.isEncrypted) {
                this.pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            if ((title = (String)this.parameters.get(JRPdfExporterParameter.METADATA_TITLE)) != null) {
                this.document.addTitle(title);
            }
            if ((author = (String)this.parameters.get(JRPdfExporterParameter.METADATA_AUTHOR)) != null) {
                this.document.addAuthor(author);
            }
            if ((subject = (String)this.parameters.get(JRPdfExporterParameter.METADATA_SUBJECT)) != null) {
                this.document.addSubject(subject);
            }
            if ((keywords = (String)this.parameters.get(JRPdfExporterParameter.METADATA_KEYWORDS)) != null) {
                this.document.addKeywords(keywords);
            }
            if ((creator = (String)this.parameters.get(JRPdfExporterParameter.METADATA_CREATOR)) != null) {
                this.document.addCreator(creator);
            } else {
                this.document.addCreator("JasperReports (" + this.jasperPrint.getName() + ")");
            }
            this.document.open();
            if (this.pdfJavaScript != null) {
                this.pdfWriter.addJavaScript(this.pdfJavaScript);
            }
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            this.initBookmarks();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
                BorderOffset.setLegacy(JRProperties.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.legacy.border.offset", false));
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        if (this.isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        this.writePageAnchor(pageIndex);
                        this.exportPage(page);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e);
        }
        catch (IOException e) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.document.close();
                }
                catch (Throwable e) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) throws DocumentException {
        Chunk chunk;
        Map pdfFontAttrs = this.getDefaultPdfFontAttributes();
        if (pdfFontAttrs == null) {
            chunk = new Chunk(" ");
        } else {
            com.lowagie.text.Font pdfFont = this.getFont(pdfFontAttrs);
            chunk = new Chunk(" ", pdfFont);
        }
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
        colText.go();
    }

    protected Map getDefaultPdfFontAttributes() {
        HashMap<JRTextAttribute, Object> attrs;
        JRStyle style = this.jasperPrint.getDefaultStyle();
        if (style != null) {
            attrs = new HashMap<JRTextAttribute, Object>();
            attrs.put(JRTextAttribute.PDF_FONT_NAME, style.getPdfFontName());
            attrs.put(JRTextAttribute.PDF_ENCODING, style.getPdfEncoding());
            attrs.put(JRTextAttribute.IS_PDF_EMBEDDED, style.isPdfEmbedded());
        } else {
            JRReportFont font = this.jasperPrint.getDefaultFont();
            if (font != null) {
                attrs = new HashMap();
                attrs.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
                attrs.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
                attrs.put(JRTextAttribute.IS_PDF_EMBEDDED, font.isPdfEmbedded() ? Boolean.TRUE : Boolean.FALSE);
            } else {
                attrs = null;
            }
        }
        return attrs;
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        List elements = page.getElements();
        this.exportElements(elements);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws DocumentException, IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, line.getLinePen(), 0);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyle() == 3) {
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()));
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()));
                        this.pdfContentByte.stroke();
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()));
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()));
                    } else {
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()));
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()));
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyle() == 3) {
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f - lineWidth / 3.0f);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f);
                }
            } else if (line.getDirection() == 1) {
                if (line.getLinePen().getLineStyle() == 3) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) + (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) + (float)ytrans);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()));
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()));
                }
            } else if (line.getLinePen().getLineStyle() == 3) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) - (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - (float)ytrans);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) + (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) + (float)ytrans);
            } else {
                this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()));
                this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()));
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.setLineCap(2);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, rectangle.getLinePen(), 2);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        float lineOffset = BorderOffset.getOffset(rectangle.getLinePen());
        if (rectangle.getMode() == 1) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()), (float)rectangle.getWidth(), (float)rectangle.getHeight(), (float)rectangle.getRadius());
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyle() == 3) {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) + lineOffset, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) + lineOffset, (float)rectangle.getWidth() - 2.0f * lineOffset, (float)rectangle.getHeight() - 2.0f * lineOffset, (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, ellipse.getLinePen(), 2);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        float lineOffset = BorderOffset.getOffset(ellipse.getLinePen());
        if (ellipse.getMode() == 1) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()), (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()), (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()));
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyle() == 3) {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) + lineWidth / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) - lineWidth / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) + lineOffset, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) + lineOffset, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) - lineOffset, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) - lineOffset);
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        if (printImage.getMode() == 1) {
            this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.rectangle((float)(printImage.getX() + this.getOffsetX()), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY()), (float)printImage.getWidth(), (float)(-printImage.getHeight()));
            this.pdfContentByte.fill();
        }
        int topPadding = printImage.getLineBox().getTopPadding();
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, printImage.getOnErrorType());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int xoffset = 0;
            int yoffset = 0;
            Chunk chunk = null;
            float scaledWidth = availableImageWidth;
            float scaledHeight = availableImageHeight;
            if (renderer.getType() == 0) {
                Image image = null;
                float xalignFactor = this.getXAlignFactor(printImage);
                float yalignFactor = this.getYAlignFactor(printImage);
                switch (printImage.getScaleImage()) {
                    case 1: {
                        renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, printImage.getOnErrorType());
                        if (renderer == null) break;
                        int normalWidth = availableImageWidth;
                        int normalHeight = availableImageHeight;
                        Dimension2D dimension = renderer.getDimension();
                        if (dimension != null) {
                            normalWidth = (int)dimension.getWidth();
                            normalHeight = (int)dimension.getHeight();
                        }
                        xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        int minWidth = Math.min(normalWidth, availableImageWidth);
                        int minHeight = Math.min(normalHeight, availableImageHeight);
                        BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
                        Graphics2D g = bi.createGraphics();
                        if (printImage.getMode() == 1) {
                            g.setColor(printImage.getBackcolor());
                            g.fillRect(0, 0, minWidth, minHeight);
                        }
                        renderer.render(g, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
                        g.dispose();
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                        image = Image.getInstance((java.awt.Image)bi, null);
                        break;
                    }
                    case 2: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(JRImageRenderer.getInstance(renderer.getImageData()), printImage.getOnErrorType());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage();
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                        break;
                    }
                    default: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(JRImageRenderer.getInstance(renderer.getImageData()), printImage.getOnErrorType());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage();
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleToFit((float)availableImageWidth, (float)availableImageHeight);
                        xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.plainWidth()));
                        yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.plainHeight()));
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        int n = yoffset = yoffset < 0 ? 0 : yoffset;
                    }
                }
                if (image != null) {
                    chunk = new Chunk(image, 0.0f, 0.0f);
                    scaledWidth = image.scaledWidth();
                    scaledHeight = image.scaledHeight();
                }
            } else {
                Graphics2D g;
                double normalWidth = availableImageWidth;
                double normalHeight = availableImageHeight;
                double displayWidth = availableImageWidth;
                double displayHeight = availableImageHeight;
                double ratioX = 1.0;
                double ratioY = 1.0;
                Rectangle2D.Double clip = null;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                    displayWidth = normalWidth;
                    displayHeight = normalHeight;
                    float xalignFactor = this.getXAlignFactor(printImage);
                    float yalignFactor = this.getYAlignFactor(printImage);
                    switch (printImage.getScaleImage()) {
                        case 1: {
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - normalWidth));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - normalHeight));
                            clip = new Rectangle2D.Double(-xoffset, -yoffset, availableImageWidth, availableImageHeight);
                            break;
                        }
                        case 2: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            normalWidth *= ratioX;
                            normalHeight *= ratioY;
                            xoffset = 0;
                            yoffset = 0;
                            break;
                        }
                        default: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - (normalWidth *= ratioX)));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - (normalHeight *= ratioY)));
                        }
                    }
                }
                PdfTemplate template = this.pdfContentByte.createTemplate((float)displayWidth, (float)displayHeight);
                Graphics2D graphics2D = g = this.forceSvgShapes ? template.createGraphicsShapes((float)displayWidth, (float)displayHeight) : template.createGraphics((float)availableImageWidth, (float)availableImageHeight, (FontMapper)new LocalFontMapper());
                if (clip != null) {
                    g.setClip(clip);
                }
                if (printImage.getMode() == 1) {
                    g.setColor(printImage.getBackcolor());
                    g.fillRect(0, 0, (int)displayWidth, (int)displayHeight);
                }
                Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, displayWidth, displayHeight);
                renderer.render(g, rectangle);
                g.dispose();
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(template, (float)ratioX, 0.0f, 0.0f, (float)ratioY, (float)(printImage.getX() + this.getOffsetX() + xoffset), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY() - (int)normalHeight - yoffset));
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
            if (chunk != null) {
                this.setAnchor(chunk, printImage, printImage);
                this.setHyperlinkInfo(chunk, printImage);
                ColumnText colText = new ColumnText(this.pdfContentByte);
                int upperY = this.jasperPrint.getPageHeight() - printImage.getY() - topPadding - this.getOffsetY() - yoffset;
                int lowerX = printImage.getX() + leftPadding + this.getOffsetX() + xoffset;
                colText.setSimpleColumn(new Phrase(chunk), (float)lowerX, (float)upperY - scaledHeight, (float)lowerX + scaledWidth, (float)upperY, scaledHeight, 0);
                colText.go();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), printImage);
        }
    }

    private float getXAlignFactor(JRPrintImage printImage) {
        float xalignFactor = 0.0f;
        switch (printImage.getHorizontalAlignment()) {
            case 3: {
                xalignFactor = 1.0f;
                break;
            }
            case 2: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage printImage) {
        float yalignFactor = 0.0f;
        switch (printImage.getVerticalAlignment()) {
            case 3: {
                yalignFactor = 1.0f;
                break;
            }
            case 2: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink link) {
        block0 : switch (link.getHyperlinkType()) {
            case 2: {
                if (link.getHyperlinkReference() == null) break;
                switch (link.getHyperlinkTarget()) {
                    case 2: {
                        chunk.setAction(PdfAction.javaScript((String)("if (app.viewerVersion < 7){this.getURL(\"" + link.getHyperlinkReference() + "\");}" + "else {app.launchURL(\"" + link.getHyperlinkReference() + "\", true);};"), (PdfWriter)this.pdfWriter));
                        break block0;
                    }
                }
                chunk.setAnchor(link.getHyperlinkReference());
                break;
            }
            case 3: {
                if (link.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(link.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (link.getHyperlinkPage() == null) break;
                chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage().intValue());
                break;
            }
            case 7: {
                String hyperlink;
                if (this.hyperlinkProducerFactory == null || (hyperlink = this.hyperlinkProducerFactory.produceHyperlink(link)) == null) break;
                switch (link.getHyperlinkTarget()) {
                    case 2: {
                        chunk.setAction(PdfAction.javaScript((String)("if (app.viewerVersion < 7){this.getURL(\"" + hyperlink + "\");}" + "else {app.launchURL(\"" + hyperlink + "\", true);};"), (PdfWriter)this.pdfWriter));
                        break block0;
                    }
                }
                chunk.setAnchor(hyperlink);
            }
        }
    }

    protected Phrase getPhrase(JRStyledText styledText, JRPrintText textElement) {
        Phrase phrase = new Phrase();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Chunk chunk = this.getChunk(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            this.setAnchor(chunk, textElement, textElement);
            this.setHyperlinkInfo(chunk, textElement);
            phrase.add((Object)chunk);
            iterator.setIndex(runLimit);
        }
        return phrase;
    }

    protected Chunk getChunk(Map attributes, String text) {
        Object script;
        com.lowagie.text.Font font = this.getFont(attributes);
        Chunk chunk = new Chunk(text, font);
        Color backcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        if (backcolor != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.leading(1.0f) / 2.0f);
            } else if (script != null && TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.leading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected com.lowagie.text.Font getFont(Map attributes) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        com.lowagie.text.Font font = null;
        PdfFont pdfFont = null;
        FontKey key = new FontKey(jrFont.getFontName(), jrFont.isBold(), jrFont.isItalic());
        pdfFont = this.fontMap != null && this.fontMap.containsKey(key) ? (PdfFont)this.fontMap.get(key) : new PdfFont(jrFont.getPdfFontName(), jrFont.getPdfEncoding(), jrFont.isPdfEmbedded());
        try {
            font = FontFactory.getFont((String)pdfFont.getPdfFontName(), (String)pdfFont.getPdfEncoding(), (boolean)pdfFont.isPdfEmbedded(), (float)jrFont.getFontSize(), (int)((pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0)), (Color)forecolor);
            if (font.getBaseFont() == null && font.family() == -1) {
                font = null;
            }
        }
        catch (Exception e) {
            initialException = e;
        }
        if (font == null) {
            byte[] bytes = null;
            try {
                bytes = JRLoader.loadBytesFromLocation(pdfFont.getPdfFontName(), this.classLoader, this.urlHandlerFactory, this.fileResolver);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Could not load the following font : \npdfFontName   : " + pdfFont.getPdfFontName() + "\npdfEncoding   : " + pdfFont.getPdfEncoding() + "\nisPdfEmbedded : " + pdfFont.isPdfEmbedded(), initialException);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont((String)pdfFont.getPdfFontName(), (String)pdfFont.getPdfEncoding(), (boolean)pdfFont.isPdfEmbedded(), (boolean)true, (byte[])bytes, null);
            }
            catch (DocumentException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            font = new com.lowagie.text.Font(baseFont, (float)jrFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0), forecolor);
        }
        return font;
    }

    protected void exportText(JRPrintText text) throws DocumentException {
        JRStyledText styledText = this.getStyledText(text, false);
        if (styledText == null) {
            return;
        }
        int textLength = styledText.length();
        int x = text.getX() + this.getOffsetX();
        int y = text.getY() + this.getOffsetY();
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getLineBox().getTopPadding();
        int leftPadding = text.getLineBox().getLeftPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        int xFillCorrection = 0;
        int yFillCorrection = 0;
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + this.getOffsetY() + text.getHeight();
                xFillCorrection = 1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + this.getOffsetX() + text.getWidth();
                yFillCorrection = -1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 3: {
                x = text.getX() + this.getOffsetX() + text.getWidth();
                y = text.getY() + this.getOffsetY() + text.getHeight();
                int tmpPadding = topPadding;
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        if (text.getMode() == 1) {
            Color backcolor = text.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle((float)(x + xFillCorrection), (float)(this.jasperPrint.getPageHeight() - y + yFillCorrection), (float)width, (float)(-height));
            this.pdfContentByte.fill();
        }
        if (textLength > 0) {
            int horizontalAlignment = 0;
            switch (text.getHorizontalAlignment()) {
                case 1: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 0;
                        break;
                    }
                    horizontalAlignment = 2;
                    break;
                }
                case 2: {
                    horizontalAlignment = 1;
                    break;
                }
                case 3: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 2;
                        break;
                    }
                    horizontalAlignment = 0;
                    break;
                }
                case 4: {
                    horizontalAlignment = 3;
                    break;
                }
                default: {
                    horizontalAlignment = 0;
                }
            }
            float verticalOffset = 0.0f;
            switch (text.getVerticalAlignment()) {
                case 1: {
                    verticalOffset = 0.0f;
                    break;
                }
                case 2: {
                    verticalOffset = ((float)(height - topPadding - bottomPadding) - text.getTextHeight()) / 2.0f;
                    break;
                }
                case 3: {
                    verticalOffset = (float)(height - topPadding - bottomPadding) - text.getTextHeight();
                    break;
                }
                default: {
                    verticalOffset = 0.0f;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(this.getPhrase(styledText, text), (float)(x + leftPadding), (float)(this.jasperPrint.getPageHeight() - y - topPadding) - verticalOffset - text.getLeadingOffset(), (float)(x + width - rightPadding), (float)(this.jasperPrint.getPageHeight() - y - height + bottomPadding), 0.0f, horizontalAlignment);
            colText.setLeading(0.0f, text.getLineSpacingFactor());
            colText.setRunDirection(text.getRunDirection() == 0 ? 2 : 3);
            colText.go();
        }
        atrans = new AffineTransform();
        atrans.rotate(-angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        this.exportBox(text.getLineBox(), text);
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), element);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
            JRPdfExporter.preparePen(this.pdfContentByte, topPen, 0);
            if (topPen.getLineStyle() == 3) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float topOffset = BorderOffset.getOffset(topPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
            JRPdfExporter.preparePen(this.pdfContentByte, leftPen, 0);
            if (leftPen.getLineStyle() == 3) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) - leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float leftOffset = BorderOffset.getOffset(leftPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) + leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
            JRPdfExporter.preparePen(this.pdfContentByte, bottomPen, 0);
            if (bottomPen.getLineStyle() == 3) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float bottomOffset = BorderOffset.getOffset(bottomPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
            JRPdfExporter.preparePen(this.pdfContentByte, rightPen, 0);
            if (rightPen.getLineStyle() == 3) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float rightOffset = BorderOffset.getOffset(rightPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    private static void preparePen(PdfContentByte pdfContentByte, JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        pdfContentByte.setLineWidth(lineWidth);
        pdfContentByte.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        switch (pen.getLineStyle()) {
            case 3: {
                pdfContentByte.setLineWidth(lineWidth / 3.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(lineWidth, lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            case 1: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            default: {
                pdfContentByte.setLineDash(0.0f);
            }
        }
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List fontDirs;
            List fontFiles = JRProperties.getProperties("net.sf.jasperreports.export.pdf.font.");
            if (!fontFiles.isEmpty()) {
                Iterator i = fontFiles.iterator();
                while (i.hasNext()) {
                    JRProperties.PropertySuffix font = (JRProperties.PropertySuffix)i.next();
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register((String)file, (String)alias);
                }
            }
            if (!(fontDirs = JRProperties.getProperties("net.sf.jasperreports.export.pdf.fontdir.")).isEmpty()) {
                Iterator i = fontDirs.iterator();
                while (i.hasNext()) {
                    JRProperties.PropertySuffix dir = (JRProperties.PropertySuffix)i.next();
                    FontFactory.registerDirectory((String)dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks() {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = this.isModeBatch && this.isCreatingBatchModeBookmarks ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level > level - 1) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        for (int i = parent.level + 1; i < level; ++i) {
            Bookmark emptyBookmark = new Bookmark(parent, parent.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
            this.bookmarkStack.push(emptyBookmark);
            parent = emptyBookmark;
        }
        Bookmark bookmark = new Bookmark(parent, x, this.jasperPrint.getPageHeight() - y, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), element.getX(), element.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws DocumentException, IOException, JRException {
        if (frame.getMode() == 1) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle((float)x, (float)(this.jasperPrint.getPageHeight() - y), (float)frame.getWidth(), (float)(-frame.getHeight()));
            this.pdfContentByte.fill();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), frame);
    }

    class LocalFontMapper
    implements FontMapper {
        public BaseFont awtToPdf(Font font) {
            return JRPdfExporter.this.getFont(font.getAttributes()).getBaseFont();
        }

        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        public void write(int b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(byte[] b) {
        }
    }

    protected static class BookmarkStack {
        LinkedList stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return (Bookmark)this.stack.removeLast();
        }

        Bookmark peek() {
            return (Bookmark)this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this(parent, new PdfDestination(0, (float)x, (float)top, 0.0f), title);
        }

        Bookmark(Bookmark parent, PdfDestination destination, String title) {
            this.pdfOutline = new PdfOutline(parent.pdfOutline, destination, title, false);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }
}

