/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.AaptManager;
import brut.util.OS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class AaptInvoker {
    private final Config mConfig;
    private final ApkInfo mApkInfo;
    private static final Logger LOGGER = Logger.getLogger(AaptInvoker.class.getName());

    public AaptInvoker(Config config, ApkInfo apkInfo) {
        this.mConfig = config;
        this.mApkInfo = apkInfo;
    }

    private File getAaptBinaryFile() throws AndrolibException {
        try {
            if (this.getAaptVersion() == 2) {
                return AaptManager.getAapt2();
            }
            return AaptManager.getAapt1();
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private int getAaptVersion() {
        return this.mConfig.isAapt2() ? 2 : 1;
    }

    private File createDoNotCompressExtensionsFile(ApkInfo apkInfo) throws AndrolibException {
        if (apkInfo.doNotCompress == null || apkInfo.doNotCompress.isEmpty()) {
            return null;
        }
        try {
            File doNotCompressFile = File.createTempFile("APKTOOL", null);
            doNotCompressFile.deleteOnExit();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(doNotCompressFile));
            for (String extension : apkInfo.doNotCompress) {
                fileWriter.write(extension);
                fileWriter.newLine();
            }
            fileWriter.close();
            return doNotCompressFile;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void invokeAapt2(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, List<String> cmd, boolean customAapt) throws AndrolibException {
        File buildDir;
        ArrayList<String> compileCommand = new ArrayList<String>(cmd);
        File resourcesZip = null;
        if (resDir != null) {
            buildDir = new File(resDir.getParent(), "build");
            resourcesZip = new File(buildDir, "resources.zip");
        }
        if (resDir != null && !resourcesZip.exists()) {
            cmd.add("compile");
            cmd.add("--dir");
            cmd.add(resDir.getAbsolutePath());
            cmd.add("--legacy");
            buildDir = new File(resDir.getParent(), "build");
            resourcesZip = new File(buildDir, "resources.zip");
            cmd.add("-o");
            cmd.add(resourcesZip.getAbsolutePath());
            if (this.mConfig.verbose) {
                cmd.add("-v");
            }
            if (this.mConfig.noCrunch) {
                cmd.add("--no-crunch");
            }
            try {
                OS.exec(cmd.toArray(new String[0]));
                LOGGER.fine("aapt2 compile command ran: ");
                LOGGER.fine(cmd.toString());
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
        if (manifest == null) {
            return;
        }
        cmd = new ArrayList<String>(compileCommand);
        cmd.add("link");
        cmd.add("-o");
        cmd.add(apkFile.getAbsolutePath());
        if (this.mApkInfo.packageInfo.forcedPackageId != null && !this.mApkInfo.sharedLibrary) {
            cmd.add("--package-id");
            cmd.add(this.mApkInfo.packageInfo.forcedPackageId);
        }
        if (this.mApkInfo.sharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mApkInfo.getMinSdkVersion() != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mApkInfo.getMinSdkVersion());
        }
        if (this.mApkInfo.getTargetSdkVersion() != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.mApkInfo.checkTargetSdkVersionBounds());
        }
        if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
            cmd.add("--rename-instrumentation-target-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
        }
        if (this.mApkInfo.versionInfo.versionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mApkInfo.versionInfo.versionCode);
        }
        if (this.mApkInfo.versionInfo.versionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mApkInfo.versionInfo.versionName);
        }
        cmd.add("--no-auto-version");
        cmd.add("--no-version-vectors");
        cmd.add("--no-version-transitions");
        cmd.add("--no-resource-deduping");
        cmd.add("--allow-reserved-package-id");
        cmd.add("--no-compile-sdk-metadata");
        if (this.mApkInfo.sparseResources) {
            cmd.add("--enable-sparse-encoding");
        }
        if (this.mApkInfo.isFrameworkApk) {
            cmd.add("-x");
        }
        if (this.mApkInfo.doNotCompress != null && !customAapt) {
            File[] extensionsFilePath = Objects.requireNonNull(this.createDoNotCompressExtensionsFile(this.mApkInfo)).getAbsolutePath();
            cmd.add("-e");
            cmd.add((String)extensionsFilePath);
        } else if (this.mApkInfo.doNotCompress != null) {
            for (String file : this.mApkInfo.doNotCompress) {
                cmd.add("-0");
                cmd.add(file);
            }
        }
        if (!this.mApkInfo.resourcesAreCompressed) {
            cmd.add("-0");
            cmd.add("arsc");
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        cmd.add("--manifest");
        cmd.add(manifest.getAbsolutePath());
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add("-R");
            cmd.add(rawDir.getAbsolutePath());
        }
        if (this.mConfig.verbose) {
            cmd.add("-v");
        }
        if (resourcesZip != null) {
            cmd.add(resourcesZip.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("aapt2 link command ran: ");
            LOGGER.fine(cmd.toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void invokeAapt1(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, List<String> cmd, boolean customAapt) throws AndrolibException {
        cmd.add("p");
        if (this.mConfig.verbose) {
            cmd.add("-v");
        }
        if (this.mConfig.updateFiles) {
            cmd.add("-u");
        }
        if (this.mConfig.debugMode) {
            cmd.add("--debug-mode");
        }
        if (this.mConfig.noCrunch) {
            cmd.add("--no-crunch");
        }
        if (this.mApkInfo.packageInfo.forcedPackageId != null && !customAapt && !this.mApkInfo.sharedLibrary) {
            cmd.add("--forced-package-id");
            cmd.add(this.mApkInfo.packageInfo.forcedPackageId);
        }
        if (this.mApkInfo.sharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mApkInfo.getMinSdkVersion() != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mApkInfo.getMinSdkVersion());
        }
        if (this.mApkInfo.getTargetSdkVersion() != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.mApkInfo.checkTargetSdkVersionBounds());
        }
        if (this.mApkInfo.getMaxSdkVersion() != null) {
            cmd.add("--max-sdk-version");
            cmd.add(this.mApkInfo.getMaxSdkVersion());
            cmd.add("--max-res-version");
            cmd.add(this.mApkInfo.getMaxSdkVersion());
        }
        if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
        }
        if (this.mApkInfo.versionInfo.versionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mApkInfo.versionInfo.versionCode);
        }
        if (this.mApkInfo.versionInfo.versionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mApkInfo.versionInfo.versionName);
        }
        cmd.add("--no-version-vectors");
        cmd.add("-F");
        cmd.add(apkFile.getAbsolutePath());
        if (this.mApkInfo.isFrameworkApk) {
            cmd.add("-x");
        }
        if (this.mApkInfo.doNotCompress != null && !customAapt) {
            File[] extensionsFilePath = Objects.requireNonNull(this.createDoNotCompressExtensionsFile(this.mApkInfo)).getAbsolutePath();
            cmd.add("-e");
            cmd.add((String)extensionsFilePath);
        } else if (this.mApkInfo.doNotCompress != null) {
            for (String file : this.mApkInfo.doNotCompress) {
                cmd.add("-0");
                cmd.add(file);
            }
        }
        if (!this.mApkInfo.resourcesAreCompressed) {
            cmd.add("-0");
            cmd.add("arsc");
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        if (resDir != null) {
            cmd.add("-S");
            cmd.add(resDir.getAbsolutePath());
        }
        if (manifest != null) {
            cmd.add("-M");
            cmd.add(manifest.getAbsolutePath());
        }
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add(rawDir.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("command ran: ");
            LOGGER.fine(cmd.toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void invokeAapt(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include) throws AndrolibException {
        String aaptPath = this.mConfig.aaptPath;
        boolean customAapt = !aaptPath.isEmpty();
        ArrayList<String> cmd = new ArrayList<String>();
        try {
            String aaptCommand = AaptManager.getAaptExecutionCommand(aaptPath, this.getAaptBinaryFile());
            cmd.add(aaptCommand);
        }
        catch (BrutException ex) {
            LOGGER.warning("aapt: " + ex.getMessage() + " (defaulting to $PATH binary)");
            cmd.add(AaptManager.getAaptBinaryName(this.getAaptVersion()));
        }
        if (this.mConfig.isAapt2()) {
            this.invokeAapt2(apkFile, manifest, resDir, rawDir, assetDir, include, cmd, customAapt);
            return;
        }
        this.invokeAapt1(apkFile, manifest, resDir, rawDir, assetDir, include, cmd, customAapt);
    }
}

