/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.VlaExtension;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VlaReaderNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "vlaExtId", "", "Ljava/lang/Integer;", "mediaSourceDescs", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nVlaReaderNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VlaReaderNode.kt\norg/jitsi/nlj/transform/node/incoming/VlaReaderNode\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n63#2,4:115\n1872#3,2:119\n1863#3:121\n1872#3,3:122\n1864#3:125\n1874#3:126\n*S KotlinDebug\n*F\n+ 1 VlaReaderNode.kt\norg/jitsi/nlj/transform/node/incoming/VlaReaderNode\n*L\n56#1:115,4\n76#1:119,2\n78#1:121\n81#1:122,3\n78#1:125\n76#1:126\n*E\n"})
public final class VlaReaderNode
extends ObserverNode {
    @NotNull
    private final Logger logger;
    @Nullable
    private Integer vlaExtId;
    @NotNull
    private MediaSourceDesc[] mediaSourceDescs;

    public VlaReaderNode(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Video Layers Allocation reader");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.mediaSourceDescs = new MediaSourceDesc[0];
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.VLA, arg_0 -> VlaReaderNode._init_$lambda$0(this, arg_0));
    }

    public /* synthetic */ VlaReaderNode(ReadOnlyStreamInformationStore readOnlyStreamInformationStore, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            logger = new LoggerImpl(Reflection.getOrCreateKotlinClass(VlaReaderNode.class).getSimpleName());
        }
        this(readOnlyStreamInformationStore, logger);
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetMediaSourcesEvent) {
            MediaSourceDesc[] mediaSourceDescArray = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
            MediaSourceDesc[] mediaSourceDescArray2 = Arrays.copyOf(mediaSourceDescArray, mediaSourceDescArray.length);
            Intrinsics.checkNotNullExpressionValue(mediaSourceDescArray2, "copyOf(...)");
            this.mediaSourceDescs = mediaSourceDescArray2;
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Media sources changed:\n" + ArraysKt.joinToString$default(this.mediaSourceDescs, null, null, null, 0, null, null, 63, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block11: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            Integer n = this.vlaExtId;
            if (n == null) break block11;
            int it = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(it);
            if (headerExtension != null) {
                List<VlaExtension.Stream> list;
                RtpPacket.HeaderExtension ext = headerExtension;
                boolean bl2 = false;
                try {
                    list = VlaExtension.Companion.parse(ext);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse VLA extension", e);
                    return;
                }
                List<VlaExtension.Stream> vla = list;
                RtpEncodingDesc[] sourceDesc = MediaSourceDescKt.findRtpSource(this.mediaSourceDescs, rtpPacket);
                this.logger.debug("Found VLA=" + vla + " for sourceDesc=" + (MediaSourceDesc)sourceDesc);
                Iterable $this$forEachIndexed$iv = vla;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void stream;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    VlaExtension.Stream stream2 = (VlaExtension.Stream)item$iv;
                    int streamIdx = n2;
                    boolean bl3 = false;
                    RtpEncodingDesc[] rtpEncodingDescArray = sourceDesc;
                    RtpEncodingDesc rtpEncoding = sourceDesc != null && (rtpEncodingDescArray = rtpEncodingDescArray.getRtpEncodings()) != null ? rtpEncodingDescArray[streamIdx] : null;
                    Iterable $this$forEach$iv = stream.getSpatialLayers();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VlaExtension.SpatialLayer spatialLayer = (VlaExtension.SpatialLayer)element$iv;
                        boolean bl4 = false;
                        int maxTl = spatialLayer.getTargetBitratesKbps().size() - 1;
                        Iterable $this$forEachIndexed$iv2 = spatialLayer.getTargetBitratesKbps();
                        boolean $i$f$forEachIndexed2 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            VlaExtension.ResolutionAndFrameRate res;
                            void targetBitrateKbps;
                            RtpLayerDesc rtpLayerDesc;
                            RtpLayerDesc rtpLayerDesc2;
                            int tlIdx;
                            block10: {
                                RtpLayerDesc[] rtpLayerDescArray;
                                int n3;
                                if ((n3 = index$iv2++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                long l = ((Number)item$iv2).longValue();
                                tlIdx = n3;
                                boolean bl5 = false;
                                if (rtpEncoding == null || (rtpLayerDescArray = rtpEncoding.getLayers$jitsi_media_transform()) == null) continue;
                                RtpLayerDesc[] rtpLayerDescArray2 = rtpLayerDescArray;
                                int n4 = rtpLayerDescArray2.length;
                                for (int i = 0; i < n4; ++i) {
                                    RtpLayerDesc rtpLayerDesc3;
                                    RtpLayerDesc it2 = rtpLayerDesc3 = rtpLayerDescArray2[i];
                                    boolean bl6 = false;
                                    if (!((it2.getSid() == spatialLayer.getId() || it2.getSid() == -1) && it2.getTid() == tlIdx)) continue;
                                    rtpLayerDesc2 = rtpLayerDesc3;
                                    break block10;
                                }
                                rtpLayerDesc2 = null;
                            }
                            if ((rtpLayerDesc = rtpLayerDesc2) == null) continue;
                            RtpLayerDesc layer = rtpLayerDesc;
                            boolean bl7 = false;
                            this.logger.debug(() -> VlaReaderNode.observe$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6$lambda$3(rtpEncoding, layer, (long)targetBitrateKbps, spatialLayer));
                            layer.setTargetBitrate-eKiYIew(Bandwidth.box-impl(BandwidthKt.getKbps((long)targetBitrateKbps)));
                            if (spatialLayer.getRes() == null) continue;
                            boolean bl8 = false;
                            if (layer.getHeight() > 0 && layer.getHeight() != res.getHeight()) {
                                this.logger.info(() -> VlaReaderNode.observe$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6$lambda$5$lambda$4((MediaSourceDesc)sourceDesc, rtpEncoding, layer, res));
                            }
                            layer.setHeight(res.getHeight());
                            double framerateFraction = 1.0 / (double)(1 << maxTl - tlIdx);
                            layer.setFrameRate((double)res.getMaxFramerate() * framerateFraction);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
    }

    private static final Unit _init_$lambda$0(VlaReaderNode this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.vlaExtId = it;
        this$0.logger.debug("VLA extension ID set to " + it);
        return Unit.INSTANCE;
    }

    private static final String observe$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6$lambda$3(RtpEncodingDesc $rtpEncoding, RtpLayerDesc $layer, long $targetBitrateKbps, VlaExtension.SpatialLayer $spatialLayer) {
        Intrinsics.checkNotNullParameter($layer, "$layer");
        Intrinsics.checkNotNullParameter($spatialLayer, "$spatialLayer");
        return "Setting target bitrate for rtpEncoding=" + $rtpEncoding + " layer=" + $layer + " to " + Bandwidth.toString-impl(BandwidthKt.getKbps($targetBitrateKbps)) + " (res=" + $spatialLayer.getRes() + ")";
    }

    private static final String observe$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7$lambda$6$lambda$5$lambda$4(MediaSourceDesc $sourceDesc, RtpEncodingDesc $rtpEncoding, RtpLayerDesc $layer, VlaExtension.ResolutionAndFrameRate $res) {
        Intrinsics.checkNotNullParameter($layer, "$layer");
        Intrinsics.checkNotNullParameter($res, "$res");
        return "Updating layer height for source " + $sourceDesc.getSourceName() + " encoding " + $rtpEncoding.getPrimarySSRC() + " layer " + $layer.indexString() + " from " + $layer.getHeight() + " to " + $res.getHeight();
    }
}

