/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import net.sf.mpxj.mpp.EncryptedDocumentInputStream;
import net.sf.mpxj.mpp.Props;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

class DocumentInputStreamFactory {
    private boolean m_encrypted;
    private byte m_encryptionCode;

    public DocumentInputStreamFactory(Props props) {
        this.m_encrypted = props.getByte(Props.PASSWORD_FLAG) != 0;
        byte by = props.getByte(Props.ENCRYPTION_CODE);
        this.m_encryptionCode = (byte)(by == 0 ? 0 : 255 - by);
    }

    public InputStream getInstance(DirectoryEntry directoryEntry, String string) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.getEntry(string);
        InputStream inputStream = this.m_encrypted ? new EncryptedDocumentInputStream(documentEntry, this.m_encryptionCode) : new DocumentInputStream(documentEntry);
        return inputStream;
    }

    public byte getEncryptionCode() {
        return this.m_encryptionCode;
    }
}

