/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PNodeFilter;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PRoot
extends PNode {
    public static final String PROPERTY_INPUT_SOURCES = "inputSources";
    public static final int PROPERTY_CODE_INPUT_SOURCES = 16384;
    protected transient boolean processingInputs;
    protected transient boolean processInputsScheduled;
    private PInputManager defaultInputManager;
    private transient List inputSources = new ArrayList();
    private transient long globalTime = System.currentTimeMillis();
    private PActivityScheduler activityScheduler = new PActivityScheduler(this);

    public boolean addActivity(PActivity pActivity) {
        this.getActivityScheduler().addActivity(pActivity);
        return true;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.activityScheduler;
    }

    public void waitForActivities() {
        PNodeFilter pNodeFilter = new PNodeFilter(){

            public boolean accept(PNode pNode) {
                return pNode instanceof PCamera && ((PCamera)pNode).getComponent() != null;
            }

            public boolean acceptChildrenOf(PNode pNode) {
                return true;
            }
        };
        while (this.activityScheduler.getActivitiesReference().size() > 0) {
            this.processInputs();
            Iterator iterator = this.getAllNodes(pNodeFilter, null).iterator();
            while (iterator.hasNext()) {
                PCamera pCamera = (PCamera)iterator.next();
                pCamera.getComponent().paintImmediately();
            }
        }
    }

    public PRoot getRoot() {
        return this;
    }

    public PInputManager getDefaultInputManager() {
        if (this.defaultInputManager == null) {
            this.defaultInputManager = new PInputManager();
            this.addInputSource(this.defaultInputManager);
        }
        return this.defaultInputManager;
    }

    public void addInputSource(InputSource inputSource) {
        this.inputSources.add(inputSource);
        this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
    }

    public void removeInputSource(InputSource inputSource) {
        this.inputSources.remove(inputSource);
        this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
    }

    public Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }

    public long getGlobalTime() {
        return this.globalTime;
    }

    public void processInputs() {
        PDebug.startProcessingInput();
        this.processingInputs = true;
        this.globalTime = System.currentTimeMillis();
        int n = this.inputSources == null ? 0 : this.inputSources.size();
        for (int i = 0; i < n; ++i) {
            InputSource inputSource = (InputSource)this.inputSources.get(i);
            inputSource.processInput();
        }
        this.activityScheduler.processActivities(this.globalTime);
        this.validateFullBounds();
        this.validateFullPaint();
        this.processingInputs = false;
        PDebug.endProcessingInput();
    }

    public void setFullBoundsInvalid(boolean bl) {
        super.setFullBoundsInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildBoundsInvalid(boolean bl) {
        super.setChildBoundsInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setPaintInvalid(boolean bl) {
        super.setPaintInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildPaintInvalid(boolean bl) {
        super.setChildPaintInvalid(bl);
        this.scheduleProcessInputsIfNeeded();
    }

    public void scheduleProcessInputsIfNeeded() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        PDebug.scheduleProcessInputs();
        if (!this.processInputsScheduled && !this.processingInputs && (this.getFullBoundsInvalid() || this.getChildBoundsInvalid() || this.getPaintInvalid() || this.getChildPaintInvalid())) {
            this.processInputsScheduled = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PRoot.this.processInputs();
                    PRoot.this.processInputsScheduled = false;
                }
            });
        }
    }

    public static interface InputSource {
        public void processInput();
    }
}

