/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 / 12) => 1
 * (12 / -6) => -2
 * (12 / 76) => 0
 * (12 / -32) => 0
 * (-6 / 12) => 0
 * (-6 / -6) => 1
 * (-6 / 76) => 0
 * (-6 / -32) => 0
 * (76 / 12) => 6
 * (76 / -6) => -12
 * (76 / 76) => 1
 * (76 / -32) => -2
 * (-32 / 12) => -2
 * (-32 / -6) => 5
 * (-32 / 76) => 0
 * (-32 / -32) => 1
 * (0 / 12) => 0
 * (0 / -6) => 0
 * (0 / 76) => 0
 * (0 / -32) => 0
 */
#version 120

void main()
{
  float[(12 / 12) == 1 ? 1 : -1] array0;
  float[(12 / -6) == -2 ? 1 : -1] array1;
  float[(12 / 76) == 0 ? 1 : -1] array2;
  float[(12 / -32) == 0 ? 1 : -1] array3;
  float[(-6 / 12) == 0 ? 1 : -1] array4;
  float[(-6 / -6) == 1 ? 1 : -1] array5;
  float[(-6 / 76) == 0 ? 1 : -1] array6;
  float[(-6 / -32) == 0 ? 1 : -1] array7;
  float[(76 / 12) == 6 ? 1 : -1] array8;
  float[(76 / -6) == -12 ? 1 : -1] array9;
  float[(76 / 76) == 1 ? 1 : -1] array10;
  float[(76 / -32) == -2 ? 1 : -1] array11;
  float[(-32 / 12) == -2 ? 1 : -1] array12;
  float[(-32 / -6) == 5 ? 1 : -1] array13;
  float[(-32 / 76) == 0 ? 1 : -1] array14;
  float[(-32 / -32) == 1 ? 1 : -1] array15;
  float[(0 / 12) == 0 ? 1 : -1] array16;
  float[(0 / -6) == 0 ? 1 : -1] array17;
  float[(0 / 76) == 0 ? 1 : -1] array18;
  float[(0 / -32) == 0 ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
