/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(22, -23, 4) << uvec3(22u, 23u, 4u)) => ivec3(92274688, -192937984, 64)
 * (ivec3(22, -23, 4) << uvec3(19u, 1u, 13u)) => ivec3(11534336, -46, 32768)
 * (ivec3(22, 23, 4) << uvec3(22u, 23u, 4u)) => ivec3(92274688, 192937984, 64)
 * (ivec3(22, 23, 4) << uvec3(19u, 1u, 13u)) => ivec3(11534336, 46, 32768)
 * (ivec3(-19, 1, -13) << uvec3(22u, 23u, 4u)) => ivec3(-79691776, 8388608, -208)
 * (ivec3(-19, 1, -13) << uvec3(19u, 1u, 13u)) => ivec3(-9961472, 2, -106496)
 * (ivec3(19, 1, 13) << uvec3(22u, 23u, 4u)) => ivec3(79691776, 8388608, 208)
 * (ivec3(19, 1, 13) << uvec3(19u, 1u, 13u)) => ivec3(9961472, 2, 106496)
 */
#version 150

void main()
{
  float[all(equal((ivec3(22, -23, 4) << uvec3(22u, 23u, 4u)), ivec3(92274688, -192937984, 64))) ? 1 : -1] array0;
  float[all(equal((ivec3(22, -23, 4) << uvec3(19u, 1u, 13u)), ivec3(11534336, -46, 32768))) ? 1 : -1] array1;
  float[all(equal((ivec3(22, 23, 4) << uvec3(22u, 23u, 4u)), ivec3(92274688, 192937984, 64))) ? 1 : -1] array2;
  float[all(equal((ivec3(22, 23, 4) << uvec3(19u, 1u, 13u)), ivec3(11534336, 46, 32768))) ? 1 : -1] array3;
  float[all(equal((ivec3(-19, 1, -13) << uvec3(22u, 23u, 4u)), ivec3(-79691776, 8388608, -208))) ? 1 : -1] array4;
  float[all(equal((ivec3(-19, 1, -13) << uvec3(19u, 1u, 13u)), ivec3(-9961472, 2, -106496))) ? 1 : -1] array5;
  float[all(equal((ivec3(19, 1, 13) << uvec3(22u, 23u, 4u)), ivec3(79691776, 8388608, 208))) ? 1 : -1] array6;
  float[all(equal((ivec3(19, 1, 13) << uvec3(19u, 1u, 13u)), ivec3(9961472, 2, 106496))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
