/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.AttackDelegate;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayerType;

public abstract class BaseDrownCommandConfig
extends AttackConfig {
    @ParametersDelegate
    ClientDelegate clientDelegate = new ClientDelegate();
    @ParametersDelegate
    private AttackDelegate attackDelegate = new AttackDelegate();
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate = new StarttlsDelegate();
    @Parameter(names={"-premasterSecretsFile"}, description="File containing captured Premaster secrets to be decrypted in hex format, one per line")
    private String premasterSecretsFilePath;

    public BaseDrownCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.attackDelegate);
        this.addDelegate(this.starttlsDelegate);
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        config.setRecordLayerType(RecordLayerType.BLOB);
        config.setHighestProtocolVersion(ProtocolVersion.SSL2);
        return config;
    }

    @Override
    public boolean isExecuteAttack() {
        return this.attackDelegate.isExecuteAttack();
    }

    public String getPremasterSecretsFilePath() {
        return this.premasterSecretsFilePath;
    }
}

