/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.AccessDecisionManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.InsufficientAuthenticationException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.vote.AccessDecisionVoter;
import org.springframework.util.Assert;

public abstract class AbstractAccessDecisionManager
implements AccessDecisionManager,
InitializingBean,
MessageSourceAware {
    private List decisionVoters;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private boolean allowIfAllAbstainDecisions = false;
    static /* synthetic */ Class class$org$springframework$security$vote$AccessDecisionVoter;

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Collection)this.decisionVoters, (String)"A list of AccessDecisionVoters is required");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    protected final void checkAllowIfAllAbstainDecisions() {
        if (!this.isAllowIfAllAbstainDecisions()) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
    }

    public List getDecisionVoters() {
        return this.decisionVoters;
    }

    public boolean isAllowIfAllAbstainDecisions() {
        return this.allowIfAllAbstainDecisions;
    }

    public void setAllowIfAllAbstainDecisions(boolean allowIfAllAbstainDecisions) {
        this.allowIfAllAbstainDecisions = allowIfAllAbstainDecisions;
    }

    public void setDecisionVoters(List newList) {
        Assert.notEmpty((Collection)newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            Assert.isInstanceOf((Class)(class$org$springframework$security$vote$AccessDecisionVoter == null ? AbstractAccessDecisionManager.class$("org.springframework.security.vote.AccessDecisionVoter") : class$org$springframework$security$vote$AccessDecisionVoter), currentObject, (String)("AccessDecisionVoter " + currentObject.getClass().getName() + " must implement AccessDecisionVoter"));
        }
        this.decisionVoters = newList;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean supports(ConfigAttribute attribute) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (!voter.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class clazz) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (voter.supports(clazz)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void decide(Authentication var1, Object var2, ConfigAttributeDefinition var3) throws AccessDeniedException, InsufficientAuthenticationException;
}

