/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeWithCPIndex;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.SignatureConverter;

public abstract class BytecodeGetPut
extends BytecodeWithCPIndex {
    BytecodeGetPut(Method method, int bci) {
        super(method, bci);
    }

    public Symbol name() {
        ConstantPool cp = this.method().getConstants();
        return cp.getNameRefAt(this.index());
    }

    public Symbol signature() {
        ConstantPool cp = this.method().getConstants();
        return cp.getSignatureRefAt(this.index());
    }

    public Field getField() {
        return this.method().getConstants().getFieldRefAt(this.index());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.indexForFieldOrMethod()));
        buf.append(" [Field ");
        StringBuffer sigBuf = new StringBuffer();
        new SignatureConverter(this.signature(), sigBuf).dispatchField();
        buf.append(sigBuf.toString().replace('/', '.'));
        buf.append(" ");
        buf.append(this.name().asString());
        buf.append("]");
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }

    public abstract boolean isStatic();
}

