/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum DataType implements MpxjEnum
{
    STRING(1),
    DATE(2),
    CURRENCY(3),
    BOOLEAN(4),
    NUMERIC(5),
    DURATION(6),
    UNITS(7),
    PERCENTAGE(8),
    ACCRUE(9),
    CONSTRAINT(10),
    RATE(11),
    PRIORITY(12),
    RELATION_LIST(13),
    TASK_TYPE(14),
    RESOURCE_TYPE(15),
    WORK(16),
    INTEGER(17),
    ASCII_STRING(18),
    SHORT(19),
    BINARY(20),
    DELAY(21),
    WORK_UNITS(22),
    WORKGROUP(23),
    GUID(24),
    RATE_UNITS(25),
    EARNED_VALUE_METHOD(26),
    RESOURCE_REQUEST_TYPE(27),
    CURRENCY_SYMBOL_POSITION(28),
    CHAR(29),
    DATE_ORDER(30),
    PROJECT_TIME_FORMAT(31),
    PROJECT_DATE_FORMAT(32),
    SCHEDULE_FROM(33),
    DAY(34),
    MAP(35),
    MPX_FILE_VERSION(36),
    MPX_CODE_PAGE(37),
    BOOKING_TYPE(38),
    TIME_UNITS(39);

    private static final DataType[] TYPE_VALUES;
    private int m_value;

    private DataType(int n2) {
        this.m_value = n2;
    }

    public static DataType getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = STRING.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static DataType getInstance(Number number) {
        int n = number == null ? -1 : NumberHelper.getInt(number);
        return DataType.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (DataType[])EnumHelper.createTypeArray(DataType.class, (int)1);
    }
}

