/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.TokenBindingExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.TokenBindingExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.TokenBindingExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.ArrayList;

public class TokenBindingExtensionHandler
extends ExtensionHandler<TokenBindingExtensionMessage> {
    public TokenBindingExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public TokenBindingExtensionParser getParser(byte[] message, int pointer) {
        return new TokenBindingExtensionParser(pointer, message);
    }

    public TokenBindingExtensionPreparator getPreparator(TokenBindingExtensionMessage message) {
        return new TokenBindingExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public TokenBindingExtensionSerializer getSerializer(TokenBindingExtensionMessage message) {
        return new TokenBindingExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(TokenBindingExtensionMessage message) {
        this.context.setTokenBindingVersion(TokenBindingVersion.getExtensionType((byte[])message.getTokenbindingVersion().getValue()));
        ArrayList<TokenBindingKeyParameters> tokenbindingKeyParameters = new ArrayList<TokenBindingKeyParameters>();
        for (byte kp : (byte[])message.getTokenbindingKeyParameters().getValue()) {
            tokenbindingKeyParameters.add(TokenBindingKeyParameters.getTokenBindingKeyParameter(kp));
        }
        this.context.setTokenBindingKeyParameters(tokenbindingKeyParameters);
        if (this.context.getTalkingConnectionEndType() == this.context.getChooser().getMyConnectionPeer()) {
            this.context.setTokenBindingNegotiatedSuccessfully(true);
        }
    }
}

