/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class FullIdent {
    private final StringBuffer mBuffer = new StringBuffer();
    private int mLineNo;
    private int mColNo;

    private FullIdent() {
    }

    public String getText() {
        return this.mBuffer.toString();
    }

    public int getLineNo() {
        return this.mLineNo;
    }

    public int getColumnNo() {
        return this.mColNo;
    }

    private void append(String aText) {
        this.mBuffer.append(aText);
    }

    private void append(DetailAST aAST) {
        this.mBuffer.append(aAST.getText());
        if (this.mLineNo == 0) {
            this.mLineNo = aAST.getLineNo();
        } else if (aAST.getLineNo() > 0) {
            this.mLineNo = Math.min(this.mLineNo, aAST.getLineNo());
        }
        if (this.mColNo == 0) {
            this.mColNo = aAST.getColumnNo();
        } else if (aAST.getColumnNo() > 0) {
            this.mColNo = Math.min(this.mColNo, aAST.getColumnNo());
        }
    }

    public static FullIdent createFullIdent(DetailAST aAST) {
        FullIdent fi = new FullIdent();
        FullIdent.extractFullIdent(fi, aAST);
        return fi;
    }

    private static void extractFullIdent(FullIdent aFull, DetailAST aAST) {
        if (aAST == null) {
            return;
        }
        if (aAST.getType() == 59) {
            FullIdent.extractFullIdent(aFull, (DetailAST)aAST.getFirstChild());
            aFull.append(".");
            FullIdent.extractFullIdent(aFull, (DetailAST)aAST.getFirstChild().getNextSibling());
        } else {
            aFull.append(aAST);
        }
    }
}

