# Casilda

A simple Wayland compositor widget for Gtk 4 which can be used to embed other
processes windows in your Gtk 4 application.

It was originally created for Cambalache's workspace using wlroots,
a modular library to create Wayland compositors.

Following Wayland tradition, this library is named after my hometown in
Santa Fe, Argentina.

## License

Casilda is distributed under the [GNU Lesser General Public License](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html),
version 2.1 only (LGPL) as described in the COPYING file.

## Source code

Source code lives on GNOME gitlab [here](https://gitlab.gnome.org/jpu/casilda)

`git clone https://gitlab.gnome.org/jpu/casilda.git`

## Dependencies

* [Meson](http://mesonbuild.com) build system
* [GTK](http://www.gtk.org) Version 4
* wlroots - Library to create Wayland compositors


## Manual installation

This is a regular meson package and can be installed the usual way.

```
# Configure project in _build directory
meson setup --wipe --prefix=~/.local _build .

# Build and install in ~/.local
ninja -C _build install
```

## How to use it

To add a Wayland compositor to your application all you have to do is create a
CasildaCompositor widget.

You can specify which UNIX socket the compositor will listen for clients
connections or let it will choose one automatically.

```
compositor = casilda_compositor_new ("/tmp/casilda-example.sock");
gtk_window_set_child (GTK_WINDOW (window), GTK_WIDGET (compositor));
```

Once the compositor is running you can connect to it by specifying the socket
in WAYLAND_DISPLAY environment variable.

```
export GDK_BACKEND=wayland
export WAYLAND_DISPLAY=/tmp/casilda-example.sock
gtk4-demo
```

If you do not want any client being able to connect to the compositor you can
pass NULL as socket and spawn the client with casilda_compositor_spawn_async()
or get an already connected socket with casilda_compositor_get_client_socket_fd()
and pass it to the client on WAYLAND_SOCKET env variable.

```
compositor = casilda_compositor_new (NULL);
gtk_window_set_child (GTK_WINDOW (window), GTK_WIDGET (compositor));
gtk_window_present (GTK_WINDOW (window));

gchar *argv[] = { "/usr/bin/gtk4-demo", NULL };
casilda_compositor_spawn_async (compositor, NULL, argv, NULL, G_SPAWN_DEFAULT, NULL, NULL, NULL, NULL);
```

## API

The api is pretty simple CasildaCompositor.

Properties:

- socket: The unix socket file to connect to this compositor (string)
- scrollable: True to make widget scrollable.

Methods:

- `casilda_compositor_get_client_socket_fd ()`
  Create a client socket file descriptor connected to this compositor ready to use by passing it to a client with
  WAYLAND_SOCKET environment variable.

- `casilda_compositor_spawn_async ()`
  Executes a child program asynchronously with the right environment to automatically connect to this compositor.

## Contributing

If you are interested in contributing you can open an issue [here](https://gitlab.gnome.org/jpu/casilda/-/issues)
and/or a merge request [here](https://gitlab.gnome.org/jpu/casilda/-/merge_requests)

## Contact

You can hang with us and ask us questions on Cambalache Matrix at #cambalache:gnome.org

[Matrix](https://matrix.to/#/#cambalache:gnome.org)
