// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file extensibility_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "extensibility_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "extensibility_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalStruct)
{

    ReturnCode_t return_code_FinalStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalStruct", type_ids_FinalStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalStruct)
    {
        StructTypeFlag struct_flags_FinalStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalStruct = "FinalStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalStruct;
        if (!tmp_ann_custom_FinalStruct.empty())
        {
            ann_custom_FinalStruct = tmp_ann_custom_FinalStruct;
        }

        CompleteTypeDetail detail_FinalStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalStruct, ann_custom_FinalStruct, type_name_FinalStruct.to_string());
        CompleteStructHeader header_FinalStruct;
        header_FinalStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalStruct);
        CompleteStructMemberSeq member_seq_FinalStruct;
        {
            TypeIdentifierPair type_ids_my_value;
            ReturnCode_t return_code_my_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_my_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_value = 0x00000000;
            bool common_my_value_ec {false};
            CommonStructMember common_my_value {TypeObjectUtils::build_common_struct_member(member_id_my_value, member_flags_my_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_value, common_my_value_ec))};
            if (!common_my_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_value = "my_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_value;
            ann_custom_FinalStruct.reset();
            CompleteMemberDetail detail_my_value = TypeObjectUtils::build_complete_member_detail(name_my_value, member_ann_builtin_my_value, ann_custom_FinalStruct);
            CompleteStructMember member_my_value = TypeObjectUtils::build_complete_struct_member(common_my_value, detail_my_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalStruct, member_my_value);
        }
        CompleteStructType struct_type_FinalStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalStruct, header_FinalStruct, member_seq_FinalStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalStruct, type_name_FinalStruct.to_string(), type_ids_FinalStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableStruct)
{

    ReturnCode_t return_code_MutableStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableStruct", type_ids_MutableStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableStruct)
    {
        StructTypeFlag struct_flags_MutableStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableStruct = "MutableStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableStruct;
        if (!tmp_ann_custom_MutableStruct.empty())
        {
            ann_custom_MutableStruct = tmp_ann_custom_MutableStruct;
        }

        CompleteTypeDetail detail_MutableStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableStruct, ann_custom_MutableStruct, type_name_MutableStruct.to_string());
        CompleteStructHeader header_MutableStruct;
        header_MutableStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableStruct);
        CompleteStructMemberSeq member_seq_MutableStruct;
        {
            TypeIdentifierPair type_ids_my_value;
            ReturnCode_t return_code_my_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_my_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_value = 0x00000000;
            bool common_my_value_ec {false};
            CommonStructMember common_my_value {TypeObjectUtils::build_common_struct_member(member_id_my_value, member_flags_my_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_value, common_my_value_ec))};
            if (!common_my_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_value = "my_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_value;
            ann_custom_MutableStruct.reset();
            CompleteMemberDetail detail_my_value = TypeObjectUtils::build_complete_member_detail(name_my_value, member_ann_builtin_my_value, ann_custom_MutableStruct);
            CompleteStructMember member_my_value = TypeObjectUtils::build_complete_struct_member(common_my_value, detail_my_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableStruct, member_my_value);
        }
        CompleteStructType struct_type_MutableStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableStruct, header_MutableStruct, member_seq_MutableStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableStruct, type_name_MutableStruct.to_string(), type_ids_MutableStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AppendableStruct_type_identifier(
        TypeIdentifierPair& type_ids_AppendableStruct)
{

    ReturnCode_t return_code_AppendableStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AppendableStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AppendableStruct", type_ids_AppendableStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AppendableStruct)
    {
        StructTypeFlag struct_flags_AppendableStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AppendableStruct = "AppendableStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AppendableStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AppendableStruct;
        AppliedAnnotationSeq tmp_ann_custom_AppendableStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AppendableStruct;
        if (!tmp_ann_custom_AppendableStruct.empty())
        {
            ann_custom_AppendableStruct = tmp_ann_custom_AppendableStruct;
        }

        CompleteTypeDetail detail_AppendableStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AppendableStruct, ann_custom_AppendableStruct, type_name_AppendableStruct.to_string());
        CompleteStructHeader header_AppendableStruct;
        header_AppendableStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AppendableStruct);
        CompleteStructMemberSeq member_seq_AppendableStruct;
        {
            TypeIdentifierPair type_ids_my_value;
            ReturnCode_t return_code_my_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_my_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_value = 0x00000000;
            bool common_my_value_ec {false};
            CommonStructMember common_my_value {TypeObjectUtils::build_common_struct_member(member_id_my_value, member_flags_my_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_value, common_my_value_ec))};
            if (!common_my_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_value = "my_value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_value;
            ann_custom_AppendableStruct.reset();
            CompleteMemberDetail detail_my_value = TypeObjectUtils::build_complete_member_detail(name_my_value, member_ann_builtin_my_value, ann_custom_AppendableStruct);
            CompleteStructMember member_my_value = TypeObjectUtils::build_complete_struct_member(common_my_value, detail_my_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_AppendableStruct, member_my_value);
        }
        CompleteStructType struct_type_AppendableStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AppendableStruct, header_AppendableStruct, member_seq_AppendableStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AppendableStruct, type_name_AppendableStruct.to_string(), type_ids_AppendableStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AppendableStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ExtensibilityStruct_type_identifier(
        TypeIdentifierPair& type_ids_ExtensibilityStruct)
{

    ReturnCode_t return_code_ExtensibilityStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ExtensibilityStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ExtensibilityStruct", type_ids_ExtensibilityStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ExtensibilityStruct)
    {
        StructTypeFlag struct_flags_ExtensibilityStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ExtensibilityStruct = "ExtensibilityStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ExtensibilityStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ExtensibilityStruct;
        AppliedAnnotationSeq tmp_ann_custom_ExtensibilityStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_ExtensibilityStruct;
        if (!tmp_ann_custom_ExtensibilityStruct.empty())
        {
            ann_custom_ExtensibilityStruct = tmp_ann_custom_ExtensibilityStruct;
        }

        CompleteTypeDetail detail_ExtensibilityStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ExtensibilityStruct, ann_custom_ExtensibilityStruct, type_name_ExtensibilityStruct.to_string());
        CompleteStructHeader header_ExtensibilityStruct;
        header_ExtensibilityStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ExtensibilityStruct);
        CompleteStructMemberSeq member_seq_ExtensibilityStruct;
        {
            TypeIdentifierPair type_ids_my_final_struct;
            ReturnCode_t return_code_my_final_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_final_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "FinalStruct", type_ids_my_final_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_final_struct)
            {
            ::register_FinalStruct_type_identifier(type_ids_my_final_struct);
            }
            StructMemberFlag member_flags_my_final_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_final_struct = 0x00000000;
            bool common_my_final_struct_ec {false};
            CommonStructMember common_my_final_struct {TypeObjectUtils::build_common_struct_member(member_id_my_final_struct, member_flags_my_final_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_final_struct, common_my_final_struct_ec))};
            if (!common_my_final_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_final_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_final_struct = "my_final_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_final_struct;
            ann_custom_ExtensibilityStruct.reset();
            CompleteMemberDetail detail_my_final_struct = TypeObjectUtils::build_complete_member_detail(name_my_final_struct, member_ann_builtin_my_final_struct, ann_custom_ExtensibilityStruct);
            CompleteStructMember member_my_final_struct = TypeObjectUtils::build_complete_struct_member(common_my_final_struct, detail_my_final_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_ExtensibilityStruct, member_my_final_struct);
        }
        {
            TypeIdentifierPair type_ids_my_mutable_struct;
            ReturnCode_t return_code_my_mutable_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_mutable_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "MutableStruct", type_ids_my_mutable_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_mutable_struct)
            {
            ::register_MutableStruct_type_identifier(type_ids_my_mutable_struct);
            }
            StructMemberFlag member_flags_my_mutable_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_mutable_struct = 0x00000001;
            bool common_my_mutable_struct_ec {false};
            CommonStructMember common_my_mutable_struct {TypeObjectUtils::build_common_struct_member(member_id_my_mutable_struct, member_flags_my_mutable_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_mutable_struct, common_my_mutable_struct_ec))};
            if (!common_my_mutable_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_mutable_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_mutable_struct = "my_mutable_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_mutable_struct;
            ann_custom_ExtensibilityStruct.reset();
            CompleteMemberDetail detail_my_mutable_struct = TypeObjectUtils::build_complete_member_detail(name_my_mutable_struct, member_ann_builtin_my_mutable_struct, ann_custom_ExtensibilityStruct);
            CompleteStructMember member_my_mutable_struct = TypeObjectUtils::build_complete_struct_member(common_my_mutable_struct, detail_my_mutable_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_ExtensibilityStruct, member_my_mutable_struct);
        }
        {
            TypeIdentifierPair type_ids_my_appendable_struct;
            ReturnCode_t return_code_my_appendable_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_appendable_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AppendableStruct", type_ids_my_appendable_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_appendable_struct)
            {
            ::register_AppendableStruct_type_identifier(type_ids_my_appendable_struct);
            }
            StructMemberFlag member_flags_my_appendable_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_appendable_struct = 0x00000002;
            bool common_my_appendable_struct_ec {false};
            CommonStructMember common_my_appendable_struct {TypeObjectUtils::build_common_struct_member(member_id_my_appendable_struct, member_flags_my_appendable_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_appendable_struct, common_my_appendable_struct_ec))};
            if (!common_my_appendable_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_appendable_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_appendable_struct = "my_appendable_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_appendable_struct;
            ann_custom_ExtensibilityStruct.reset();
            CompleteMemberDetail detail_my_appendable_struct = TypeObjectUtils::build_complete_member_detail(name_my_appendable_struct, member_ann_builtin_my_appendable_struct, ann_custom_ExtensibilityStruct);
            CompleteStructMember member_my_appendable_struct = TypeObjectUtils::build_complete_struct_member(common_my_appendable_struct, detail_my_appendable_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_ExtensibilityStruct, member_my_appendable_struct);
        }
        CompleteStructType struct_type_ExtensibilityStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ExtensibilityStruct, header_ExtensibilityStruct, member_seq_ExtensibilityStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ExtensibilityStruct, type_name_ExtensibilityStruct.to_string(), type_ids_ExtensibilityStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ExtensibilityStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
