/* procstats.c -- Eat Stats and update the systems tables.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua_4_taylor.h"
#include "../pcdl.h"

#if TAYLOR_UUCP

int
DEFUN_VOID (read_stats_log)
{
  int stat_status;
  FILE * fp;
  char FileName[LPNMAX];
  struct stats entry;
  BOOLEAN first_line = TRUE;

  debug_filename (FileName);
  
#ifdef DEBUG
  if (be_verbose)
    fputs ("\nProcessing Stats:\n", stderr);
#endif
  
  sprintf (FileName, "%s/%s", logs_prefix_path_opt, STATS_NAME);

  if ((fp = fopen (FileName, "r")) == (FILE *) NULL)
    {
      LOG ("cannot open %s", FileName);
      return ERROR;
    }

  entry.System = entry.User = 0;
#ifdef TAYLOR_LOGS_PATCH
  entry.PortName = 0;
#endif
  
  while ((stat_status = GetStats (fp, &entry)) != EOF)
    {
      Date_t date;
      Time_t time;
      system_rec_t * sr;
      day_rec_t * dr;
      user_rec_t * ur;
      
      if (just_some_system_opt)
	{
	  if ((sr = search_system (entry.System)) == (system_rec_t *) NULL || sr->Killed)
	    continue;
	}
      else
	sr = insert_system (entry.System);

      if (first_line && (StatStartingTime > entry.TimeStamp || StatStartingTime == 0.0))
	{
	  StatStartingTime = entry.TimeStamp;
	  first_line = FALSE;
	}
      
      julian_to_dt (entry.TimeStamp, &date, &time);
      
      ur = insert_user (entry.User);
      dr = insert_day (date);

#ifdef TAYLOR_LOGS_PATCH
      if (entry.PortName)
	{
	  port_rec_t * pa = insert_port (entry.PortName);
	  
	  pa->Activity[time.Hour * 3 + (time.Min / 20)] += entry.Bytes;
	}
#endif
      
      if (!sr->Killed)
	{
	  if (pcd_names_count)
	    {
	      int phone_tb = get_phone_timeband (date.DayOfWeek, time.Hour, time.Min);
	      
	      if (sr->PhoneCost == 0)
		system_alloc_phone_costs (sr);
	      
	      sr->PhoneCost[phone_tb] += entry.Time;
	    }
	  
	  if (date.Month == sr->History.LastMonthProcessed)
	    sr->History.MonthlyActivity[date.Month - 1] += entry.Bytes;
	  else
	    {
	      sr->History.MonthlyActivity[date.Month - 1] = entry.Bytes;
	      sr->History.LastMonthProcessed = date.Month;
	    }
	  if (entry.Direction == SENT)
	    {
	      sr->Out.Time += entry.Time;
	      sr->Out.Bytes += entry.Bytes;
	      sr->Out.Files++;
	      dr->Out.Bytes += entry.Bytes;
	      dr->Out.Time += entry.Time;
	      dr->Out.Files++;
	      if (!ur->Killed)
		{
		  ur->Out.Files++;
		  ur->Out.Bytes += entry.Bytes;
		  ur->Out.Time += entry.Time;
		}
	    }
	  else
	    {
	      sr->In.Time += entry.Time;
	      sr->In.Bytes += entry.Bytes;
	      sr->In.Files++;
	      dr->In.Time += entry.Time;
	      dr->In.Bytes += entry.Bytes;
	      dr->In.Files++;
	      if (!ur->Killed)
		{
		  ur->In.Files++;
		  ur->In.Bytes += entry.Bytes;
		  ur->In.Time += entry.Time;
		}
	    }
	}
    }
  fclose (fp);
  if (StatEndingTime < entry.TimeStamp)
    StatEndingTime = entry.TimeStamp;
  
  xfree (entry.User);
  xfree (entry.System);
#ifdef TAYLOR_LOGS_PATCH  
  xfree (entry.PortName);
#endif

  return (stat_status == EOF ? OK : ERROR);
}

#endif /* TAYLOR_UUCP */
