/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Inject;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.config.BasicConfigManager;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.ResolverUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.StepPluginMeta;
import org.pentaho.di.trans.step.Messages;
import org.pentaho.di.trans.step.StepCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedStepsConfigManager<T extends StepPluginMeta>
extends BasicConfigManager<T> {
    @Inject
    String packages;

    @Override
    public Collection<T> load() throws KettleConfigException {
        int oldLogLevel = LogWriter.getInstance().getLogLevel();
        ResolverUtil resolver = new ResolverUtil();
        String allPackages = this.packages;
        String extraPackages = System.getProperty("KETTLE_PLUGIN_PACKAGES");
        if (!Const.isEmpty((String)extraPackages)) {
            allPackages = allPackages + "," + extraPackages;
        }
        resolver.find((ResolverUtil.Test)new ResolverUtil.AnnotatedWith(Step.class), allPackages != null ? allPackages.split(",") : new String[]{});
        LinkedHashSet<StepPluginMeta> steps = new LinkedHashSet<StepPluginMeta>(resolver.size());
        for (Class clazz : resolver.getClasses()) {
            String category;
            String packageName;
            Step step = clazz.getAnnotation(Step.class);
            String[] stepName = step.name();
            if (stepName.length == 1 && stepName[0].equals("")) {
                stepName = new String[]{clazz.getName()};
            }
            if (Const.isEmpty((String)(packageName = step.i18nPackageName()))) {
                packageName = Messages.class.getPackage().getName();
            }
            String altPackageName = clazz.getPackage().getName();
            LogWriter.getInstance().setLogLevel(3);
            String description = BaseMessages.getString((String)packageName, (String)step.description());
            if (description.startsWith("!") && description.endsWith("!")) {
                description = Messages.getString(step.description());
            }
            LogWriter.getInstance().setLogLevel(oldLogLevel);
            if (description.startsWith("!") && description.endsWith("!")) {
                description = BaseMessages.getString((String)altPackageName, (String)step.description());
            }
            LogWriter.getInstance().setLogLevel(3);
            String tooltip = BaseMessages.getString((String)packageName, (String)step.tooltip());
            if (tooltip.startsWith("!") && tooltip.endsWith("!")) {
                tooltip = Messages.getString(step.tooltip());
            }
            LogWriter.getInstance().setLogLevel(oldLogLevel);
            if (tooltip.startsWith("!") && tooltip.endsWith("!")) {
                tooltip = BaseMessages.getString((String)altPackageName, (String)step.tooltip());
            }
            if (step.category() != -1) {
                category = StepCategory.BRIDGE_ANNOTATION_CATEGORY_NUMBERS[step.category()].getName();
            } else {
                LogWriter.getInstance().setLogLevel(3);
                category = BaseMessages.getString((String)packageName, (String)step.categoryDescription());
                if (category.startsWith("!") && category.endsWith("!")) {
                    category = Messages.getString(step.categoryDescription());
                }
                LogWriter.getInstance().setLogLevel(oldLogLevel);
                if (category.startsWith("!") && category.endsWith("!")) {
                    category = BaseMessages.getString((String)altPackageName, (String)step.categoryDescription());
                }
            }
            steps.add(new StepPluginMeta(clazz, stepName, description, tooltip, step.image(), category));
        }
        return steps;
    }
}

