/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends ClassLoader {
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final Set excludedPackages = Collections.synchronizedSet(new HashSet());
    private final Set excludedClasses = Collections.synchronizedSet(new HashSet());

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        this.excludedPackages.add("java.");
        this.excludedPackages.add("javax.");
        this.excludedPackages.add("sun.");
    }

    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        this.excludedClasses.add(className);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.isEligibleForOverriding(name) && (result = this.findLoadedClass(name)) == null) {
            String internalName = name.replace('.', '/') + CLASS_FILE_SUFFIX;
            InputStream is = this.getParent().getResourceAsStream(internalName);
            if (is != null) {
                try {
                    byte[] bytes = FileCopyUtils.copyToByteArray(is);
                    byte[] transformed = this.transformIfNecessary(name, bytes);
                    result = this.defineClass(name, transformed, 0, transformed.length);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
                }
            }
        }
        if (result != null) {
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        if (this.excludedClasses.contains(className)) {
            return false;
        }
        Iterator it = this.excludedPackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    protected byte[] transformIfNecessary(String name, byte[] bytes) {
        return bytes;
    }
}

