/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils.resolver;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class ResourceResolverTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest == null ? (class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest = ResourceResolverTest.class$("org.apache.xml.security.test.utils.resolver.ResourceResolverTest")) : class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest).getName());
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest == null ? (class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest = ResourceResolverTest.class$("org.apache.xml.security.test.utils.resolver.ResourceResolverTest")) : class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest);
    }

    public ResourceResolverTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest == null ? (class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest = ResourceResolverTest.class$("org.apache.xml.security.test.utils.resolver.ResourceResolverTest")) : class$org$apache$xml$security$test$utils$resolver$ResourceResolverTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public static void testCustomResolver() throws Exception {
        String string = "org.apache.xml.security.test.utils.resolver.OfflineResolver";
        ResourceResolver.registerAtStart((String)string);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setValue("http://www.apache.org");
        ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, (String)"http://www.apache.org");
        try {
            attr.setValue("http://xmldsig.pothole.com/xml-stylesheet.txt");
            resourceResolver.resolve(attr, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ResourceResolverTest.fail((String)(attr.getValue() + " should be resolvable by the OfflineResolver"));
        }
        try {
            attr.setValue("http://www.apache.org");
            resourceResolver.resolve(attr, null);
            ResourceResolverTest.fail((String)(attr.getValue() + " should not be resolvable by the OfflineResolver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testLocalFileWithEmptyBaseURI() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Attr attr = document.createAttribute("URI");
        String string = System.getProperty("basedir");
        String string2 = new File(string, "build.xml").toURI().toString();
        attr.setValue(string2);
        ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, (String)string2);
        try {
            resourceResolver.resolve(attr, "");
        }
        catch (Exception exception) {
            ResourceResolverTest.fail((String)exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

