/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

public final class RouteHandlers {
    private RouteHandlers() {
    }

    public static void setContentType(final RoutingContext context, final String defaultContentType) {
        final HttpServerResponse response = context.response();
        context.addHeadersEndHandler((Handler)new Handler<Void>(){

            public void handle(Void aVoid) {
                MultiMap headers = response.headers();
                if (!headers.contains(HttpHeaders.CONTENT_TYPE)) {
                    String acceptableContentType = context.getAcceptableContentType();
                    if (acceptableContentType != null) {
                        headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)acceptableContentType);
                    } else if (defaultContentType != null) {
                        headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)defaultContentType);
                    }
                }
            }
        });
    }
}

