/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.action;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.action.Timer;
import org.openhab.core.scheduler.ScheduledCompletableFuture;
import org.openhab.core.scheduler.Scheduler;
import org.openhab.core.scheduler.SchedulerRunnable;

@NonNullByDefault
public class TimerImpl
implements Timer {
    private final Scheduler scheduler;
    private final SchedulerRunnable runnable;
    private final @Nullable String identifier;
    private ScheduledCompletableFuture<?> future;

    public TimerImpl(Scheduler scheduler, ZonedDateTime startTime, SchedulerRunnable runnable) {
        this(scheduler, startTime, runnable, null);
    }

    public TimerImpl(Scheduler scheduler, ZonedDateTime startTime, SchedulerRunnable runnable, @Nullable String identifier) {
        this.scheduler = scheduler;
        this.runnable = runnable;
        this.identifier = identifier;
        this.future = scheduler.schedule(runnable, identifier, (TemporalAdjuster)startTime.toInstant());
    }

    @Override
    public synchronized boolean cancel() {
        return this.future.cancel(true);
    }

    @Override
    public synchronized boolean reschedule(ZonedDateTime newTime) {
        this.future.cancel(false);
        this.future = this.scheduler.schedule(this.runnable, this.identifier, (TemporalAdjuster)newTime.toInstant());
        return true;
    }

    @Override
    public synchronized @Nullable ZonedDateTime getExecutionTime() {
        return this.future.isCancelled() ? null : this.future.getScheduledTime();
    }

    @Override
    public synchronized boolean isActive() {
        return !this.future.isDone();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.isActive() && ZonedDateTime.now().isAfter(this.future.getScheduledTime());
    }

    @Override
    public synchronized boolean hasTerminated() {
        return this.future.isDone();
    }
}

