/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntime;
import org.graalvm.visualvm.lib.jfluid.server.ThreadInfo;
import org.graalvm.visualvm.lib.jfluid.server.system.Stacks;
import org.graalvm.visualvm.lib.jfluid.server.system.Timers;

public class ProfilerRuntimeCPU
extends ProfilerRuntime {
    private static final boolean DEBUG = false;
    private static int maxStringLength = 1024;
    static final Object NO_RET_VALUE = new Object();
    private static int nProfiledThreadsLimit;
    protected static int nProfiledThreadsAllowed;
    protected static int stackDepthLimit;
    protected static boolean enableFirstTimeMethodInvoke;
    protected static volatile boolean recursiveInstrumentationDisabled;
    protected static boolean absoluteTimerOn;
    protected static boolean threadCPUTimerOn;
    protected static boolean waitTrackingEnabled;
    protected static boolean sleepTrackingEnabled;
    protected static boolean[] instrMethodInvoked;
    private static boolean javaLangReflectMethodInvokeInterceptEnabled;
    private static Method getRequestedSessionIdMethod;
    private static Method getMethodMethod;
    private static Method getServletPathMethod;

    public static long getAbsTimeStampInCollectedFormat() {
        return Timers.getCurrentTimeInCounts() & 0xFFFFFFFFFFFFFFL;
    }

    public static void setInstrMethodsInvoked(boolean[] methodInvoked) {
        instrMethodInvoked = methodInvoked;
    }

    public static void setJavaLangReflectMethodInvokeInterceptEnabled(boolean v) {
        javaLangReflectMethodInvokeInterceptEnabled = v;
    }

    public static void setNProfiledThreadsLimit(int num) {
        nProfiledThreadsLimit = nProfiledThreadsAllowed = num;
    }

    public static void setMaxStringLength(int maxLength) {
        maxStringLength = maxLength;
    }

    public static void setStackDepthLimit(int num) {
        stackDepthLimit = num;
    }

    public static void setWaitAndSleepTracking(boolean waitTracking, boolean sleepTracking) {
        waitTrackingEnabled = waitTracking;
        sleepTrackingEnabled = sleepTracking;
    }

    public static void setTimerTypes(boolean absolute, boolean threadCPU) {
        if (threadCPU != threadCPUTimerOn && Platform.isSolaris()) {
            Timers.enableMicrostateAccounting((boolean)threadCPU);
        }
        absoluteTimerOn = absolute;
        threadCPUTimerOn = threadCPU;
    }

    public static void enableFirstTimeMethodInvoke(boolean enabled) {
        enableFirstTimeMethodInvoke = enabled;
    }

    public static void createThreadInfoForCurrentThread() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        ti.initialize();
        ti.useEventBuffer();
        ti.inCallGraph = false;
    }

    public static void handleJavaLangReflectMethodInvoke(Method method) {
        if (!javaLangReflectMethodInvokeInterceptEnabled) {
            return;
        }
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        externalActionsHandler.handleReflectiveInvoke(method);
        --ti.inProfilingRuntimeMethod;
    }

    public static void handleServletDoMethod(Object request) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized()) {
            System.out.println("No thread for servlet request");
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilerRuntimeCPU.servletDoMethodHook(ti, request);
        --ti.inProfilingRuntimeMethod;
    }

    public static void resetProfilerCollectors() {
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    public static void resumeCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, ti.absEntryTime, ti.threadEntryTime);
        --ti.inProfilingRuntimeMethod;
    }

    public static ThreadInfo suspendCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return ti;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.absEntryTime = Timers.getCurrentTimeInCounts();
        if (threadCPUTimerOn) {
            ti.threadEntryTime = Timers.getThreadCPUTimeInNanos();
        }
        return ti;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    protected static void createNewDataStructures() {
        ProfilerRuntime.createNewDataStructures();
        Stacks.createNativeStackFrameBuffer(100);
    }

    protected static long currentTimeInCounts() {
        return Timers.getCurrentTimeInCounts();
    }

    protected static void enableProfiling(boolean v) {
        recursiveInstrumentationDisabled = !v;
    }

    protected static long monitorEntryCPU(ThreadInfo ti, Object monitor, ThreadInfo ownerTi) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)22, ti, monitor, ownerTi);
        }
        return -1L;
    }

    protected static long monitorExitCPU(ThreadInfo ti, Object monitor) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)23, ti, monitor);
        }
        return -1L;
    }

    protected static long sleepEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)24, ti);
        }
        return -1L;
    }

    protected static long sleepExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)25, ti);
        }
        return -1L;
    }

    protected static long waitEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)20, ti);
        }
        return -1L;
    }

    protected static long waitExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)21, ti);
        }
        return -1L;
    }

    protected static long parkEntryCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)26, ti);
        }
        return -1L;
    }

    protected static long parkExitCPU(ThreadInfo ti) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (ti.isInitialized() && ti.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)27, ti);
        }
        return -1L;
    }

    protected static void firstTimeMethodInvoke(ThreadInfo ti, char methodId) {
        if (enableFirstTimeMethodInvoke) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            long threadTimeStamp = threadCPUTimerOn ? Timers.getThreadCPUTimeInNanos() : 0L;
            externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
            ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
        }
    }

    static void writeServletDoMethod(ThreadInfo ti, String method, String servletPath, String sessionId) {
        int curPos = ti.evBufPos;
        int fullInfoLen = 2 + servletPath.length() * 2 + 4;
        if (curPos + fullInfoLen > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        int methodId = -1;
        int sessionHash = -1;
        if ("GET".equals(method)) {
            methodId = 1;
        } else if ("POST".equals(method)) {
            methodId = 2;
        } else if ("PUT".equals(method)) {
            methodId = 3;
        } else if ("DELETE".equals(method)) {
            methodId = 4;
        }
        if (sessionId != null) {
            sessionHash = sessionId.hashCode();
        }
        evBuf[curPos++] = 30;
        evBuf[curPos++] = methodId;
        byte[] name = servletPath.getBytes();
        int len = name.length;
        evBuf[curPos++] = (byte)(len >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(len & 0xFF);
        System.arraycopy(name, 0, evBuf, curPos, len);
        curPos += len;
        evBuf[curPos++] = (byte)(sessionHash >> 24 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 16 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash & 0xFF);
        ti.evBufPos = curPos;
    }

    static void writeTimeStampedEvent(byte eventType, ThreadInfo ti, char methodId) {
        int curPos;
        int[] stackFrameIds = null;
        int currentStackDepth = 0;
        if (eventType == 3) {
            if (ti.stackDepth == 0) {
                stackFrameIds = new int[100];
                currentStackDepth = Stacks.getCurrentStackFrameIds(ti.getThread(), stackFrameIds.length, stackFrameIds);
                currentStackDepth -= 3;
            } else {
                stackFrameIds = new int[]{};
            }
        }
        if ((curPos = ti.evBufPos) + currentStackDepth * 4 > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        if (!ti.isInitialized()) {
            return;
        }
        evBuf[curPos++] = eventType;
        evBuf[curPos++] = (byte)(methodId >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(methodId & 0xFF);
        if (absoluteTimerOn) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            evBuf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        }
        if (threadCPUTimerOn) {
            long threadTimeStamp = Timers.getThreadCPUTimeInNanos();
            evBuf[curPos++] = (byte)(threadTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp & 0xFFL);
        }
        if (stackFrameIds != null) {
            evBuf[curPos++] = (byte)(currentStackDepth >> 16 & 0xFF);
            evBuf[curPos++] = (byte)(currentStackDepth >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(currentStackDepth & 0xFF);
            int frameIdx = 3;
            for (int i = 0; i < currentStackDepth; ++i) {
                evBuf[curPos++] = (byte)(stackFrameIds[frameIdx] >> 24 & 0xFF);
                evBuf[curPos++] = (byte)(stackFrameIds[frameIdx] >> 16 & 0xFF);
                evBuf[curPos++] = (byte)(stackFrameIds[frameIdx] >> 8 & 0xFF);
                evBuf[curPos++] = (byte)(stackFrameIds[frameIdx] & 0xFF);
                ++frameIdx;
            }
        }
        ti.evBufPos = curPos;
    }

    static long writeWaitTimeEvent(byte eventType, ThreadInfo ti) {
        return ProfilerRuntimeCPU.writeWaitTimeEvent(eventType, ti, null);
    }

    static void writeParametersEvent(ThreadInfo ti) {
        int fullInfoLen;
        int curPos;
        List pars = ti.getParameters();
        int parsLength = 0;
        if (pars != null) {
            for (int i = 0; i < pars.size(); ++i) {
                parsLength += 1 + ProfilerRuntimeCPU.getParSize(pars.get(i));
            }
        }
        if ((curPos = ti.evBufPos) + (fullInfoLen = 2 + parsLength) > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        evBuf[curPos++] = 35;
        if (pars != null) {
            evBuf[curPos++] = (byte)pars.size();
            for (int i = 0; i < pars.size(); ++i) {
                curPos = ProfilerRuntimeCPU.writeParameter(evBuf, curPos, pars.get(i));
            }
            ti.clearParameters();
        } else {
            evBuf[curPos++] = 0;
        }
        ti.evBufPos = curPos;
    }

    static void writeRetValue(Object ret, ThreadInfo ti) {
        if (ret != NO_RET_VALUE) {
            ti.addParameter(ret != null ? ProfilerRuntimeCPU.convertToString(ret) : "");
            ProfilerRuntimeCPU.writeParametersEvent(ti);
        }
    }

    private static void servletDoMethodHook(ThreadInfo ti, Object request) {
        String servletPath = null;
        String method = null;
        String requestedSessionId = null;
        if (getRequestedSessionIdMethod == null) {
            try {
                Class<?> requestClass = request.getClass();
                getRequestedSessionIdMethod = requestClass.getMethod("getRequestedSessionId", null);
                getMethodMethod = requestClass.getMethod("getMethod", null);
                getServletPathMethod = requestClass.getMethod("getServletPath", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try {
            requestedSessionId = (String)getRequestedSessionIdMethod.invoke(request, null);
            method = (String)getMethodMethod.invoke(request, null);
            servletPath = (String)getServletPathMethod.invoke(request, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        ProfilerRuntimeCPU.writeServletDoMethod(ti, method, servletPath, requestedSessionId);
    }

    public static void addParameter(boolean b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(b);
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(char b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Character(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(byte b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Byte(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(short b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Short(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(int b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Integer(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(long b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Long(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(float b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Float(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(double b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(new Double(b));
        --ti.inProfilingRuntimeMethod;
    }

    public static void addParameter(Object b) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.addParameter(b != null ? ProfilerRuntimeCPU.convertToString(b) : "");
        --ti.inProfilingRuntimeMethod;
    }

    private static int getParSize(Object p) {
        Class<?> type = p.getClass();
        if (type == Integer.class) {
            return 4;
        }
        if (type == Boolean.class) {
            return 1;
        }
        if (type == Byte.class) {
            return 1;
        }
        if (type == Short.class) {
            return 2;
        }
        if (type == Character.class) {
            return 2;
        }
        if (type == Long.class) {
            return 8;
        }
        if (type == Float.class) {
            return 4;
        }
        if (type == Double.class) {
            return 8;
        }
        return 2 + ProfilerRuntimeCPU.truncatedByteLength((String)p);
    }

    private static int writeParameter(byte[] evBuf, int curPos, Object p) {
        Class<?> type = p.getClass();
        if (type == Integer.class) {
            int vp = (Integer)p;
            evBuf[curPos++] = 73;
            evBuf[curPos++] = (byte)(vp >> 24 & 0xFF);
            evBuf[curPos++] = (byte)(vp >> 16 & 0xFF);
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(vp & 0xFF);
        } else if (type == Boolean.class) {
            boolean vp = (Boolean)p;
            evBuf[curPos++] = 90;
            evBuf[curPos++] = (byte)(vp ? 1 : 0);
        } else if (type == Byte.class) {
            byte vp = (Byte)p;
            evBuf[curPos++] = 66;
            evBuf[curPos++] = vp;
        } else if (type == Short.class) {
            short vp = (Short)p;
            evBuf[curPos++] = 83;
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(vp & 0xFF);
        } else if (type == Character.class) {
            char vp = ((Character)p).charValue();
            evBuf[curPos++] = 67;
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(vp & 0xFF);
        } else if (type == Long.class) {
            long vp = (Long)p;
            evBuf[curPos++] = 74;
            evBuf[curPos++] = (byte)(vp >> 56 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(vp & 0xFFL);
        } else if (type == Float.class) {
            int vp = Float.floatToIntBits(((Float)p).floatValue());
            evBuf[curPos++] = 70;
            evBuf[curPos++] = (byte)(vp >> 24 & 0xFF);
            evBuf[curPos++] = (byte)(vp >> 16 & 0xFF);
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(vp & 0xFF);
        } else if (type == Double.class) {
            long vp = Double.doubleToLongBits((Double)p);
            evBuf[curPos++] = 68;
            evBuf[curPos++] = (byte)(vp >> 56 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(vp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(vp & 0xFFL);
        } else {
            String sp = (String)p;
            int lengthBytes = ProfilerRuntimeCPU.truncatedByteLength(sp);
            evBuf[curPos++] = 76;
            evBuf[curPos++] = (byte)(lengthBytes >> 8 & 0xFF);
            evBuf[curPos++] = (byte)(lengthBytes & 0xFF);
            for (int i = 0; i < lengthBytes / 2; ++i) {
                char ch = sp.charAt(i);
                evBuf[curPos++] = (byte)(ch >> 8 & 0xFF);
                evBuf[curPos++] = (byte)(ch & 0xFF);
            }
        }
        return curPos;
    }

    static String convertToString(Object o) {
        String clazz = o.getClass().getName();
        if (clazz.startsWith("java.lang.")) {
            return o.toString();
        }
        if (clazz.equals("java.sql.Date")) {
            return String.valueOf(((Date)o).getTime());
        }
        if (clazz.equals("java.sql.Timestamp")) {
            return String.valueOf(((Date)o).getTime());
        }
        if (clazz.equals("java.math.BigDecimal")) {
            return o.toString();
        }
        return ProfilerRuntimeCPU.getObjectId(o, clazz);
    }

    private static int truncatedByteLength(String s) {
        int length = s.length();
        if (length < maxStringLength) {
            return length * 2;
        }
        return maxStringLength * 2;
    }

    private static String getObjectId(Object o, String clazz) {
        return clazz + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    static {
        stackDepthLimit = Integer.MAX_VALUE;
        recursiveInstrumentationDisabled = false;
        javaLangReflectMethodInvokeInterceptEnabled = false;
    }
}

