# Introduction

Thank you for your interest in contributing to [Cargo]! This guide provides an
overview of how to contribute to Cargo, how to dive into the code, and how the
testing infrastructure works.

There are many ways to contribute, such as [helping other users], [filing
issues], improving [the documentation], [triaging issues], [fixing bugs], and
working on [small] and [large features].

If you have a general question about Cargo or its internals, feel free to ask
on [Zulip].

This guide assumes you have some familiarity with Rust, and how to use Cargo,
[rustup], and general development tools like [git].

Please also read the [Rust Code of Conduct].

[Cargo]: https://doc.rust-lang.org/cargo/
[Zulip]: https://rust-lang.zulipchat.com/#narrow/stream/246057-t-cargo
[Rust Code of Conduct]: https://www.rust-lang.org/policies/code-of-conduct
[helping other users]: https://users.rust-lang.org/
[filing issues]: issues.md
[rustup]: https://rust-lang.github.io/rustup/
[git]: https://git-scm.com/
[the documentation]: https://github.com/rust-lang/cargo/tree/master/src/doc
[fixing bugs]: process/index.md#working-on-issues
[small]: process/index.md#working-on-small-features
[large features]: process/index.md#working-on-large-features
[triaging issues]: issues.md#triaging-issues
