/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.io.AbstractPrimitiveTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.tools.I18n;

public class DownloadPrimitivesTask
extends AbstractPrimitiveTask {
    private final List<PrimitiveId> ids;

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation) {
        this(layer, ids, fullRelation, null);
    }

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation, ProgressMonitor progressMonitor) {
        super(I18n.tr("Download objects", new Object[0]), progressMonitor, layer);
        this.ids = ids;
        this.setZoom(true);
        this.setDownloadRelations(true, fullRelation);
    }

    @Override
    protected void initMultiFetchReader(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to download ...", new Object[0]));
        for (PrimitiveId id : this.ids) {
            OsmPrimitive osm = this.layer.data.getPrimitiveById(id);
            if (osm == null) {
                switch (id.getType()) {
                    case NODE: {
                        osm = new Node(id.getUniqueId());
                        break;
                    }
                    case WAY: {
                        osm = new Way(id.getUniqueId());
                        break;
                    }
                    case RELATION: {
                        osm = new Relation(id.getUniqueId());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            reader.append(osm);
        }
    }
}

