/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.core.Const;

public class ValueInteger
implements ValueInterface,
Cloneable {
    private long number;
    private int length;

    public ValueInteger() {
        this.number = 0L;
        this.length = -1;
    }

    public ValueInteger(long number) {
        this.number = number;
        this.length = -1;
    }

    public int getType() {
        return 5;
    }

    public String getTypeDesc() {
        return "Integer";
    }

    public String getString() {
        return Long.toString(this.number);
    }

    public double getNumber() {
        return this.number;
    }

    public Date getDate() {
        return new Date(this.number);
    }

    public boolean getBoolean() {
        return this.number != 0L;
    }

    public long getInteger() {
        return this.number;
    }

    public void setSerializable(Serializable ser) {
    }

    public void setString(String string) {
        this.number = Const.toLong(string, 0L);
    }

    public void setNumber(double number) {
        this.number = Math.round(number);
    }

    public void setDate(Date date) {
        this.number = date.getTime();
    }

    public void setBoolean(boolean bool) {
        this.number = bool ? 1L : 0L;
    }

    public void setInteger(long number) {
        this.number = number;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return 0;
    }

    public void setLength(int length, int precision) {
        this.length = length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
    }

    public Object clone() {
        try {
            ValueInteger retval = (ValueInteger)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BigDecimal getBigNumber() {
        return new BigDecimal(this.number);
    }

    public void setBigNumber(BigDecimal number) {
        this.number = number.longValue();
    }

    public Serializable getSerializable() {
        return new Long(this.number);
    }

    public byte[] getBytes() {
        return null;
    }

    public void setBytes(byte[] b) {
    }
}

