/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Arguments {
    public static final String HELP = "--help";
    public static final String SCRIPT_FILE = "--file=";
    private boolean isHelp;
    private Map<String, String> options = Collections.emptyMap();
    private String command;
    private String scriptFile;
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();

    public static Map<String, String> getToolOptions() {
        return Collections.unmodifiableMap(OPTIONS);
    }

    private Arguments() {
    }

    public boolean isHelp() {
        return this.isHelp;
    }

    public String getCommand() {
        return this.command;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static Arguments parseArguments(String[] args) {
        String arg;
        int i;
        Arguments arguments = new Arguments();
        if (args == null || args.length == 0) {
            return arguments;
        }
        HashMap<String, String> opts = new HashMap<String, String>();
        for (i = 0; i < args.length && (arg = args[i]).startsWith("--"); ++i) {
            int sep;
            if (HELP.equals(arg)) {
                arguments.isHelp = true;
                return arguments;
            }
            if (arg.startsWith(SCRIPT_FILE)) {
                sep = arg.indexOf("=");
                arguments.scriptFile = arg.substring(sep + 1);
                continue;
            }
            if (arg.contains("=")) {
                sep = arg.indexOf("=");
                String opt = arg.substring(2, sep);
                String val = arg.substring(sep + 1);
                opts.put(opt, val);
                continue;
            }
            opts.put(arg.substring(2, arg.length()), null);
        }
        arguments.options = Collections.unmodifiableMap(opts);
        StringBuilder builder = new StringBuilder();
        while (i < args.length) {
            String cmd = args[i];
            builder.append(cmd).append(" ");
            ++i;
        }
        arguments.command = builder.length() == 0 ? null : builder.toString().trim();
        return arguments;
    }

    static {
        OPTIONS.put(HELP, "Display help");
        OPTIONS.put(SCRIPT_FILE, "Path to file containing CLI commands to execute");
    }
}

