/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.snmp.SnmpClient;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;

public class SnmpClientRequestAggregator
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(SnmpClientRequestAggregator.class);
    private final ExecutorService executor;

    public SnmpClientRequestAggregator(int threadPoolSize, String threadPoolName) {
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new NamedThreadFactory(threadPoolName));
    }

    public Request createRequest(SnmpClient client) {
        return new Request(client, this.executor);
    }

    public void await(Request[] requests, int timeoutMillis) throws ExecutionException, TimeoutException {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(requests).map(Request::toCompletableFuture).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(futures).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            logger.error("an unexpected error happened while executing SNMP requests", e.getCause());
            throw e;
        }
        catch (InterruptedException e) {
            logger.error("worker thread was interrupted while executing SNMP requests. Aborting", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        boolean terminated = this.executor.isTerminated();
        if (terminated) {
            return;
        }
        this.executor.shutdown();
        try {
            terminated = this.executor.awaitTermination(1L, TimeUnit.MINUTES);
            if (!terminated) {
                this.executor.shutdownNow();
                terminated = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            if (!terminated) {
                logger.info("failed to stop multi-thread request aggregator pool. Ignoring");
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger threadNumber = new AtomicInteger(0);
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        public NamedThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread newThread = this.defaultThreadFactory.newThread(runnable);
            newThread.setName(String.format("%s-%d", this.name, this.threadNumber.addAndGet(1)));
            return newThread;
        }
    }

    public static class Request {
        private final Executor executor;
        private final SnmpClient client;
        private final ConcurrentLinkedQueue<CompletableFuture<Map<String, ?>>> futures = new ConcurrentLinkedQueue();
        private final Map<String, Object> result = new ConcurrentHashMap<String, Object>();

        public Request(SnmpClient client, Executor executor) {
            this.client = client;
            this.executor = executor;
        }

        public void get(Target<Address> target, OID[] oids) {
            this.submitRequestTask(target, "get", oids, Map.of(), () -> {
                try {
                    return this.client.get(target, oids);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
        }

        public void walk(Target<Address> target, OID oid) {
            this.submitRequestTask(target, "walk", new OID[]{oid}, Map.of(), () -> this.client.walk(target, oid));
        }

        public void table(Target<Address> target, String tableName, OID[] oids) {
            this.submitRequestTask(target, "table", oids, Map.of("table_name", tableName), () -> this.client.table(target, tableName, oids));
        }

        private void submitRequestTask(Target<Address> target, String operation, OID[] oids, Map<String, String> extraLogDetails, Supplier<Map<String, ?>> task) {
            Supplier<Map> logPropertiesSupplier = () -> Request.createLogDetails(target, oids, extraLogDetails);
            CompletionStage future = CompletableFuture.supplyAsync(task, this.executor).exceptionally(ex -> this.handleRequestException(operation, (Throwable)ex, (Supplier<Map<String, String>>)logPropertiesSupplier));
            ((CompletableFuture)future).thenAccept(data -> this.handleRequestData(operation, (Map<String, ?>)data, (Supplier<Map<String, String>>)logPropertiesSupplier));
            this.futures.add((CompletableFuture<Map<String, ?>>)future);
        }

        private void handleRequestData(String operation, Map<String, ?> data, Supplier<Map<String, String>> logPropertiesSupplier) {
            if (data != null && !data.isEmpty()) {
                this.result.putAll(data);
            } else if (data != null && logger.isDebugEnabled()) {
                logger.debug("`{}` operation returned no response. {}", (Object)operation, logPropertiesSupplier.get());
            }
        }

        private Map<String, ?> handleRequestException(String operation, Throwable ex, Supplier<Map<String, String>> logPropertiesSupplier) {
            Throwable throwable = this.getWrappedException(ex);
            Map<String, String> logProperties = logPropertiesSupplier.get();
            if (logger.isDebugEnabled()) {
                logger.error("error invoking `{}` operation, ignoring. {}", (Object)operation, logProperties, (Object)throwable);
            } else {
                String errorMessage = throwable != null ? throwable.getMessage() : null;
                logger.error("error invoking `{}` operation: {}, ignoring. {}", (Object)operation, (Object)errorMessage, logProperties);
            }
            return null;
        }

        private Throwable getWrappedException(Throwable throwable) {
            if (throwable instanceof CompletionException && throwable.getCause() != null) {
                return throwable.getCause();
            }
            return throwable;
        }

        static Map<String, String> createLogDetails(Target<Address> target, OID[] oids, Map<String, String> extraDetails) {
            HashMap<String, String> map = new HashMap<String, String>(extraDetails);
            map.putIfAbsent("host", String.valueOf(target.getAddress()));
            map.putIfAbsent("oids", Arrays.toString(oids));
            return map;
        }

        public CompletableFuture<Void> getResultAsync(Consumer<Map<String, Object>> consumer) {
            return this.toCompletableFuture().thenAccept(p -> consumer.accept(new HashMap<String, Object>(this.result)));
        }

        CompletableFuture<Void> toCompletableFuture() {
            return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
        }
    }
}

