/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSource {
    public final Bounds bounds;
    public final String origin;

    public DataSource(Bounds bounds, String origin) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
        this.bounds = bounds;
        this.origin = origin;
    }

    public DataSource(DataSource source) {
        this(source.bounds, source.origin);
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataSource that = (DataSource)obj;
        return Objects.equals(this.bounds, that.bounds) && Objects.equals(this.origin, that.origin);
    }

    public String toString() {
        return "DataSource [bounds=" + this.bounds + ", origin=" + this.origin + ']';
    }

    public static Area getDataSourceArea(Collection<DataSource> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            return null;
        }
        Path2D.Double p = new Path2D.Double();
        for (DataSource source : dataSources) {
            p.append(source.bounds.asRect(), false);
        }
        return new Area(p);
    }

    public static List<Bounds> getDataSourceBounds(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            return null;
        }
        ArrayList<Bounds> ret = new ArrayList<Bounds>(dataSources.size());
        for (DataSource ds : dataSources) {
            if (ds.bounds == null) continue;
            ret.add(ds.bounds);
        }
        return ret;
    }
}

