/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.openstreetmap.josm.tools.Logging;

public class CacheEntryAttributes
extends ElementAttributes {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attrs = new ConcurrentHashMap<String, String>(RESERVED_KEYS.size());
    private static final String NO_TILE_AT_ZOOM = "noTileAtZoom";
    private static final String ETAG = "Etag";
    private static final String LAST_MODIFICATION = "lastModification";
    private static final String EXPIRATION_TIME = "expirationTime";
    private static final String HTTP_RESPONSE_CODE = "httpResponseCode";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String EXCEPTION = "exception";
    private static final Set<String> RESERVED_KEYS = new HashSet<String>(Arrays.asList("noTileAtZoom", "Etag", "lastModification", "expirationTime", "httpResponseCode", "errorMessage", "exception"));

    public CacheEntryAttributes() {
        this.attrs.put(NO_TILE_AT_ZOOM, "false");
        this.attrs.put(LAST_MODIFICATION, "0");
        this.attrs.put(EXPIRATION_TIME, "0");
        this.attrs.put(HTTP_RESPONSE_CODE, "200");
    }

    public boolean isNoTileAtZoom() {
        return Boolean.toString(true).equals(this.attrs.get(NO_TILE_AT_ZOOM));
    }

    public void setNoTileAtZoom(boolean noTileAtZoom) {
        this.attrs.put(NO_TILE_AT_ZOOM, Boolean.toString(noTileAtZoom));
    }

    public String getEtag() {
        return this.attrs.get(ETAG);
    }

    public void setEtag(String etag) {
        if (etag != null) {
            this.attrs.put(ETAG, etag);
        }
    }

    private long getLongAttr(String key) {
        try {
            return Long.parseLong(this.attrs.computeIfAbsent(key, k -> "0"));
        }
        catch (NumberFormatException e) {
            this.attrs.put(key, "0");
            return 0L;
        }
    }

    public long getLastModification() {
        return this.getLongAttr(LAST_MODIFICATION);
    }

    public void setLastModification(long lastModification) {
        this.attrs.put(LAST_MODIFICATION, Long.toString(lastModification));
    }

    public long getExpirationTime() {
        return this.getLongAttr(EXPIRATION_TIME);
    }

    public void setExpirationTime(long expirationTime) {
        this.attrs.put(EXPIRATION_TIME, Long.toString(expirationTime));
    }

    public void setResponseCode(int responseCode) {
        this.attrs.put(HTTP_RESPONSE_CODE, Integer.toString(responseCode));
    }

    public int getResponseCode() {
        return (int)this.getLongAttr(HTTP_RESPONSE_CODE);
    }

    public void setMetadata(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (RESERVED_KEYS.contains(e.getKey())) {
                Logging.info("Metadata key configuration contains key {0} which is reserved for internal use");
                continue;
            }
            this.attrs.put(e.getKey(), e.getValue());
        }
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public String getErrorMessage() {
        return this.attrs.get(ERROR_MESSAGE);
    }

    public void setError(Exception error) {
        this.setErrorMessage(Logging.getErrorMessage(error));
    }

    public void setErrorMessage(String message) {
        this.attrs.put(ERROR_MESSAGE, message);
    }

    public void setException(Exception e) {
        this.attrs.put(EXCEPTION, e.getClass().getCanonicalName());
    }

    public Optional<Class<? extends Exception>> getException() {
        String className = this.attrs.get(EXCEPTION);
        if (className == null) {
            return Optional.empty();
        }
        try {
            Class<?> klass = Class.forName(className);
            if (Exception.class.isAssignableFrom(klass)) {
                return Optional.of(klass.asSubclass(Exception.class));
            }
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            Logging.trace(ex);
        }
        return Optional.empty();
    }
}

