/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding.vector;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.Record;
import java.util.Objects;

public class PlainPaddingVector
extends PaddingVector {
    private final ByteArrayExplicitValueModification modification;

    public PlainPaddingVector(String name, String identifier, ByteArrayExplicitValueModification modification) {
        super(name, identifier);
        this.modification = modification;
    }

    public ByteArrayExplicitValueModification getModification() {
        return this.modification;
    }

    @Override
    public Record createRecord() {
        Record r = new Record();
        r.prepareComputations();
        ModifiableByteArray byteArray = new ModifiableByteArray();
        byteArray.setModification((VariableModification)this.modification);
        r.getComputations().setPlainRecordBytes(byteArray);
        return r;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode(this.modification);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlainPaddingVector other = (PlainPaddingVector)obj;
        return Objects.equals(this.modification, other.modification);
    }

    public String toString() {
        return "" + this.name + "{modification=" + this.modification + '}';
    }

    @Override
    public int getRecordLength(CipherSuite testedSuite, ProtocolVersion testedVersion, int appDataLength) {
        Record r = this.createRecord();
        r.getComputations().setPlainRecordBytes(new byte[appDataLength]);
        int size = ((byte[])r.getComputations().getPlainRecordBytes().getValue()).length;
        return size;
    }
}

