import {
  AuthenticatedExtendedCardNotConfiguredError,
  PushNotificationNotSupportedError,
  TaskNotCancelableError,
  TaskNotFoundError,
  UnsupportedOperationError
} from "../../../chunk-EGOOH5HP.js";
import {
  A2AServiceClient
} from "../../../chunk-QQCCX2KH.js";
import {
  FromProto,
  ToProto
} from "../../../chunk-U3QAVT4H.js";
import "../../../chunk-UHZEIZLS.js";

// src/client/transports/grpc/grpc_transport.ts
import * as grpc from "@grpc/grpc-js";
var GrpcTransport = class _GrpcTransport {
  grpcCallOptions;
  grpcClient;
  constructor(options) {
    this.grpcCallOptions = options.grpcCallOptions;
    this.grpcClient = new A2AServiceClient(
      options.endpoint,
      options.grpcChannelCredentials ?? grpc.credentials.createInsecure()
    );
  }
  async getExtendedAgentCard(options) {
    const rpcResponse = await this._sendGrpcRequest(
      "getAgentCard",
      void 0,
      options,
      this.grpcClient.getAgentCard.bind(this.grpcClient),
      ToProto.getAgentCardRequest,
      FromProto.agentCard
    );
    return rpcResponse;
  }
  async sendMessage(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "sendMessage",
      params,
      options,
      this.grpcClient.sendMessage.bind(this.grpcClient),
      ToProto.messageSendParams,
      FromProto.sendMessageResult
    );
    return rpcResponse;
  }
  async *sendMessageStream(params, options) {
    yield* this._sendGrpcStreamingRequest(
      "sendStreamingMessage",
      params,
      options,
      this.grpcClient.sendStreamingMessage.bind(this.grpcClient),
      ToProto.messageSendParams
    );
  }
  async setTaskPushNotificationConfig(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "createTaskPushNotificationConfig",
      params,
      options,
      this.grpcClient.createTaskPushNotificationConfig.bind(this.grpcClient),
      ToProto.taskPushNotificationConfigCreate,
      FromProto.taskPushNotificationConfig
    );
    return rpcResponse;
  }
  async getTaskPushNotificationConfig(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "getTaskPushNotificationConfig",
      params,
      options,
      this.grpcClient.getTaskPushNotificationConfig.bind(this.grpcClient),
      ToProto.getTaskPushNotificationConfigParams,
      FromProto.taskPushNotificationConfig
    );
    return rpcResponse;
  }
  async listTaskPushNotificationConfig(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "listTaskPushNotificationConfig",
      params,
      options,
      this.grpcClient.listTaskPushNotificationConfig.bind(this.grpcClient),
      ToProto.listTaskPushNotificationConfigParams,
      FromProto.listTaskPushNotificationConfig
    );
    return rpcResponse;
  }
  async deleteTaskPushNotificationConfig(params, options) {
    await this._sendGrpcRequest(
      "deleteTaskPushNotificationConfig",
      params,
      options,
      this.grpcClient.deleteTaskPushNotificationConfig.bind(this.grpcClient),
      ToProto.deleteTaskPushNotificationConfigParams,
      () => {
      }
    );
  }
  async getTask(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "getTask",
      params,
      options,
      this.grpcClient.getTask.bind(this.grpcClient),
      ToProto.taskQueryParams,
      FromProto.task
    );
    return rpcResponse;
  }
  async cancelTask(params, options) {
    const rpcResponse = await this._sendGrpcRequest(
      "cancelTask",
      params,
      options,
      this.grpcClient.cancelTask.bind(this.grpcClient),
      ToProto.cancelTaskRequest,
      FromProto.task
    );
    return rpcResponse;
  }
  async *resubscribeTask(params, options) {
    yield* this._sendGrpcStreamingRequest(
      "taskSubscription",
      params,
      options,
      this.grpcClient.taskSubscription.bind(this.grpcClient),
      ToProto.taskIdParams
    );
  }
  async _sendGrpcRequest(method, params, options, call, parser, converter) {
    return new Promise((resolve, reject) => {
      let onAbort;
      const clientCall = call(
        parser(params),
        this._buildMetadata(options),
        this.grpcCallOptions ?? {},
        (error, response) => {
          if (options?.signal && onAbort) {
            options.signal.removeEventListener("abort", onAbort);
          }
          if (error) {
            return reject(_GrpcTransport.mapToError(error, method));
          }
          resolve(converter(response));
        }
      );
      if (options?.signal) {
        if (options.signal.aborted) {
          clientCall.cancel();
        } else {
          onAbort = () => clientCall.cancel();
          options.signal.addEventListener("abort", onAbort);
        }
      }
    });
  }
  async *_sendGrpcStreamingRequest(method, params, options, call, parser) {
    const streamResponse = call(
      parser(params),
      this._buildMetadata(options),
      this.grpcCallOptions ?? {}
    );
    let onAbort;
    if (options?.signal) {
      if (options.signal.aborted) {
        streamResponse.cancel();
      } else {
        onAbort = () => streamResponse.cancel();
        options.signal.addEventListener("abort", onAbort);
      }
    }
    try {
      for await (const response of streamResponse) {
        yield FromProto.messageStreamResult(response);
      }
    } catch (error) {
      if (this.isServiceError(error)) {
        throw _GrpcTransport.mapToError(error, method);
      } else {
        throw new Error(`GRPC error for ${String(method)}!`, {
          cause: error
        });
      }
    } finally {
      if (options?.signal && onAbort) {
        options.signal.removeEventListener("abort", onAbort);
      }
      streamResponse.cancel();
    }
  }
  isServiceError(error) {
    return typeof error === "object" && error !== null && "code" in error;
  }
  _buildMetadata(options) {
    const metadata = new grpc.Metadata();
    if (options?.serviceParameters) {
      for (const [key, value] of Object.entries(options.serviceParameters)) {
        metadata.set(key, value);
      }
    }
    return metadata;
  }
  // TODO: the logic of mapToError will be removed in v1.0.0 with the enriched error model (https://a2a-protocol.org/latest/specification/#106-error-handling)
  static mapToError(error, method) {
    switch (error.code) {
      case grpc.status.NOT_FOUND:
        return new TaskNotFoundError(error.details);
      case grpc.status.FAILED_PRECONDITION:
        if (method === "cancelTask") {
          return new TaskNotCancelableError(error.details);
        }
        if (method === "getAgentCard") {
          return new AuthenticatedExtendedCardNotConfiguredError(error.details);
        }
        break;
      case grpc.status.UNIMPLEMENTED:
        if ([
          "getTaskPushNotificationConfig",
          "createTaskPushNotificationConfig",
          "deleteTaskPushNotificationConfig",
          "listTaskPushNotificationConfig"
        ].includes(method)) {
          return new PushNotificationNotSupportedError(error.details);
        }
        if (["getAgentCard", "taskSubscription"].includes(method)) {
          return new UnsupportedOperationError(error.details);
        }
        break;
      //TODO: add case for grpc.status.INVALID_ARGUMENT and grpc.status.INTERNAL (the respective a2a errors are not implemented yet)
      default:
        break;
    }
    return new Error(`GRPC error for ${String(method)}! ${error.code} ${error.details}`, {
      cause: error
    });
  }
};
var GrpcTransportFactory = class _GrpcTransportFactory {
  constructor(options) {
    this.options = options;
  }
  static name = "GRPC";
  get protocolName() {
    return _GrpcTransportFactory.name;
  }
  async create(url, _agentCard) {
    return new GrpcTransport({
      endpoint: url,
      grpcChannelCredentials: this.options?.grpcChannelCredentials,
      grpcCallOptions: this.options?.grpcCallOptions
    });
  }
};
export {
  GrpcTransport,
  GrpcTransportFactory
};
