/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.AbstractSVGFactoryModule;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.HeadlessSVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGImageFactoryModule
extends AbstractSVGFactoryModule {
    @Override
    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        try {
            long version = data.getVersion(caller);
            HeadlessSVGUserAgent userAgent = new HeadlessSVGUserAgent();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            SVGDocument document = (SVGDocument)loader.loadDocument(String.valueOf(data.getKey().getIdentifier()), data.getResourceAsStream(caller));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode node = builder.build(ctx, (Document)document);
            Rectangle2D bounds = node.getBounds();
            StaticRenderer staticRenderer = new StaticRenderer();
            staticRenderer.setDoubleBuffered(true);
            staticRenderer.setTree(node);
            staticRenderer.updateOffScreen((int)bounds.getWidth(), (int)bounds.getHeight());
            return new SimpleResource(data.getKey(), staticRenderer.getOffScreen(), Image.class, version);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to process SVG file", e);
        }
    }
}

