/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;

    protected INTELMapTexture() {
        throw new UnsupportedOperationException();
    }

    public static native void glSyncTextureINTEL(@NativeType(value="GLuint") int var0);

    public static native void glUnmapTexture2DINTEL(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1);

    public static native long nglMapTexture2DINTEL(int var0, int var1, int var2, long var3, long var5);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") IntBuffer stride, @NativeType(value="GLenum *") IntBuffer layout) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, (int)1);
            Checks.check((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097)));
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") IntBuffer stride, @NativeType(value="GLenum *") IntBuffer layout, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, (int)1);
            Checks.check((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") IntBuffer stride, @NativeType(value="GLenum *") IntBuffer layout, long length, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, (int)1);
            Checks.check((Buffer)layout, (int)1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress((IntBuffer)stride), MemoryUtil.memAddress((IntBuffer)layout));
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") int[] stride, @NativeType(value="GLenum *") int[] layout) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])stride, (int)1);
            Checks.check((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((int)texture, (int)level, (int)access, (int[])stride, (int[])layout, (long)__functionAddress);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097)));
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") int[] stride, @NativeType(value="GLenum *") int[] layout, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])stride, (int)1);
            Checks.check((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((int)texture, (int)level, (int)access, (int[])stride, (int[])layout, (long)__functionAddress);
        int length = INTELMapTexture.getStride(stride) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer glMapTexture2DINTEL(@NativeType(value="GLuint") int texture, @NativeType(value="GLint") int level, @NativeType(value="GLbitfield") int access, @NativeType(value="GLint *") int[] stride, @NativeType(value="GLenum *") int[] layout, long length, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = GL.getICD().glMapTexture2DINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])stride, (int)1);
            Checks.check((int[])layout, (int)1);
        }
        long __result = JNI.callPPP((int)texture, (int)level, (int)access, (int[])stride, (int[])layout, (long)__functionAddress);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    private static int getStride(IntBuffer stride) {
        return stride.get(stride.position());
    }

    private static int getStride(int[] stride) {
        return stride[0];
    }

    static {
        GL.initialize();
    }
}

