/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import io.methvin.watcher.DirectoryChangeEvent;
import java.io.IOException;

@FunctionalInterface
public interface DirectoryChangeListener {
    public static DirectoryChangeListener of(final DirectoryChangeListener ... directoryChangeListenerArray) {
        return new DirectoryChangeListener(){

            @Override
            public void onEvent(DirectoryChangeEvent directoryChangeEvent) throws IOException {
                for (DirectoryChangeListener directoryChangeListener : directoryChangeListenerArray) {
                    directoryChangeListener.onEvent(directoryChangeEvent);
                }
            }

            @Override
            public void onException(Exception exception) {
                for (DirectoryChangeListener directoryChangeListener : directoryChangeListenerArray) {
                    directoryChangeListener.onException(exception);
                }
            }

            @Override
            public void onIdle(int n) {
                for (DirectoryChangeListener directoryChangeListener : directoryChangeListenerArray) {
                    directoryChangeListener.onIdle(n);
                }
            }

            @Override
            public boolean isWatching() {
                boolean bl = false;
                for (DirectoryChangeListener directoryChangeListener : directoryChangeListenerArray) {
                    bl |= directoryChangeListener.isWatching();
                }
                return bl;
            }
        };
    }

    public void onEvent(DirectoryChangeEvent var1) throws IOException;

    default public boolean isWatching() {
        return true;
    }

    default public void onIdle(int n) {
    }

    default public void onException(Exception exception) {
    }
}

